/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import java.util.List;
import jogamp.opengl.Debug;

public class DefaultGLCapabilitiesChooser
implements GLCapabilitiesChooser {
    private static final boolean DEBUG;
    private static final int NO_SCORE = -9999999;
    private static final int DOUBLE_BUFFER_MISMATCH_PENALTY = 1000;
    private static final int OPAQUE_MISMATCH_PENALTY = 750;
    private static final int STENCIL_MISMATCH_PENALTY = 500;
    private static final int MULTISAMPLE_MISMATCH_PENALTY = 500;
    private static final int MULTISAMPLE_EXTENSION_MISMATCH_PENALTY = 250;
    private static final int COLOR_MISMATCH_PENALTY_SCALE = 36;
    private static final int DEPTH_MISMATCH_PENALTY_SCALE = 6;
    private static final int ACCUM_MISMATCH_PENALTY_SCALE = 1;
    private static final int STENCIL_MISMATCH_PENALTY_SCALE = 3;
    private static final int MULTISAMPLE_MISMATCH_PENALTY_SCALE = 3;

    @Override
    public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List<? extends CapabilitiesImmutable> list, int n2) {
        int n3;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        int n4;
        int n5;
        int n6;
        int n7;
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Null desired capabilities");
        }
        if (0 == list.size()) {
            throw new NativeWindowException("Empty available capabilities");
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = (GLCapabilitiesImmutable)capabilitiesImmutable;
        int n8 = list.size();
        if (DEBUG) {
            ExceptionUtils.dumpStack(System.err);
            System.err.println("Desired: " + gLCapabilitiesImmutable2);
            System.err.println("Available: " + n8);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                System.err.println(i2 + ": " + list.get(i2));
            }
            System.err.println("Window system's recommended choice: " + n2);
        }
        if (n2 >= 0 && n2 < n8 && null != list.get(n2)) {
            if (DEBUG) {
                System.err.println("Choosing window system's recommended choice of " + n2);
                System.err.println(list.get(n2));
            }
            return n2;
        }
        int[] nArray = new int[n8];
        for (n7 = 0; n7 < nArray.length; ++n7) {
            nArray[n7] = -9999999;
        }
        n7 = gLCapabilitiesImmutable2.getNumSamples();
        for (n6 = 0; n6 < n8; ++n6) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable3 = (GLCapabilitiesImmutable)list.get(n6);
            if (gLCapabilitiesImmutable3 == null || gLCapabilitiesImmutable2.isOnscreen() && !gLCapabilitiesImmutable3.isOnscreen() || !gLCapabilitiesImmutable2.isOnscreen() && (gLCapabilitiesImmutable2.isPBuffer() && !gLCapabilitiesImmutable3.isPBuffer() || gLCapabilitiesImmutable2.isBitmap() && !gLCapabilitiesImmutable3.isBitmap()) || gLCapabilitiesImmutable2.getStereo() != gLCapabilitiesImmutable3.getStereo()) continue;
            n5 = gLCapabilitiesImmutable3.getNumSamples();
            n4 = 0;
            n4 += 36 * (gLCapabilitiesImmutable3.getRedBits() + gLCapabilitiesImmutable3.getGreenBits() + gLCapabilitiesImmutable3.getBlueBits() + gLCapabilitiesImmutable3.getAlphaBits() - (gLCapabilitiesImmutable2.getRedBits() + gLCapabilitiesImmutable2.getGreenBits() + gLCapabilitiesImmutable2.getBlueBits() + gLCapabilitiesImmutable2.getAlphaBits()));
            n4 += 6 * DefaultGLCapabilitiesChooser.sign(n4) * Math.abs(gLCapabilitiesImmutable3.getDepthBits() - gLCapabilitiesImmutable2.getDepthBits());
            n4 += 1 * DefaultGLCapabilitiesChooser.sign(n4) * Math.abs(gLCapabilitiesImmutable3.getAccumRedBits() + gLCapabilitiesImmutable3.getAccumGreenBits() + gLCapabilitiesImmutable3.getAccumBlueBits() + gLCapabilitiesImmutable3.getAccumAlphaBits() - (gLCapabilitiesImmutable2.getAccumRedBits() + gLCapabilitiesImmutable2.getAccumGreenBits() + gLCapabilitiesImmutable2.getAccumBlueBits() + gLCapabilitiesImmutable2.getAccumAlphaBits()));
            n4 += 3 * DefaultGLCapabilitiesChooser.sign(n4) * (gLCapabilitiesImmutable3.getStencilBits() - gLCapabilitiesImmutable2.getStencilBits());
            n4 += 3 * DefaultGLCapabilitiesChooser.sign(n4) * (n5 - n7);
            if (gLCapabilitiesImmutable3.getDoubleBuffered() != gLCapabilitiesImmutable2.getDoubleBuffered()) {
                n4 += DefaultGLCapabilitiesChooser.sign(n4) * 1000;
            }
            if (gLCapabilitiesImmutable3.isBackgroundOpaque() != gLCapabilitiesImmutable2.isBackgroundOpaque()) {
                n4 += DefaultGLCapabilitiesChooser.sign(n4) * 750;
            }
            if (gLCapabilitiesImmutable2.getStencilBits() > 0 && gLCapabilitiesImmutable3.getStencilBits() == 0) {
                n4 += DefaultGLCapabilitiesChooser.sign(n4) * 500;
            }
            if (n7 > 0) {
                if (n5 == 0) {
                    n4 += DefaultGLCapabilitiesChooser.sign(n4) * 500;
                }
                if (!gLCapabilitiesImmutable2.getSampleExtension().equals(gLCapabilitiesImmutable3.getSampleExtension())) {
                    n4 += DefaultGLCapabilitiesChooser.sign(n4) * 250;
                }
            }
            nArray[n6] = n4;
        }
        n6 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = nArray[n5];
            if (n4 == -9999999 || !(gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list.get(n5)).getHardwareAccelerated()) continue;
            n3 = Math.abs(n4);
            if (n6 != 0 && n3 <= n9) continue;
            n6 = 1;
            n9 = n3;
        }
        if (n6 != 0) {
            for (n5 = 0; n5 < n8; ++n5) {
                n4 = nArray[n5];
                if (n4 == -9999999 || (gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list.get(n5)).getHardwareAccelerated()) continue;
                if (n4 <= 0) {
                    n4 -= n9;
                } else if (n4 > 0) {
                    n4 += n9;
                }
                nArray[n5] = n4;
            }
        }
        if (DEBUG) {
            System.err.print("Scores: [");
            for (n5 = 0; n5 < n8; ++n5) {
                if (n5 > 0) {
                    System.err.print(",");
                }
                System.err.print(" " + n5 + ": " + nArray[n5]);
            }
            System.err.println(" ]");
        }
        n5 = -9999999;
        n4 = -1;
        for (int i3 = 0; i3 < n8; ++i3) {
            n3 = nArray[i3];
            if (n3 == -9999999 || n5 != -9999999 && (Math.abs(n3) >= Math.abs(n5) || DefaultGLCapabilitiesChooser.sign(n5) >= 0 && DefaultGLCapabilitiesChooser.sign(n3) <= 0)) continue;
            n5 = n3;
            n4 = i3;
        }
        if (n4 < 0) {
            throw new NativeWindowException("Unable to select one of the provided GLCapabilities");
        }
        if (DEBUG) {
            System.err.println("Chosen index: " + n4);
            System.err.println("Chosen capabilities:");
            System.err.println(list.get(n4));
        }
        return n4;
    }

    private static int sign(int n2) {
        if (n2 < 0) {
            return -1;
        }
        return 1;
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined("jogl.debug.CapabilitiesChooser", true);
    }
}

