/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.MouseEvent;
import jogamp.newt.Debug;

public class PinchToZoomGesture
implements GestureHandler {
    public static final boolean DEBUG = Debug.debug("Window.MouseEvent");
    private final NativeSurface surface;
    private final boolean allowMorePointer;
    private float zoom;
    private int zoomLastEdgeDist;
    private boolean zoomFirstTouch;
    private boolean zoomMode;
    private ZoomEvent zoomEvent;
    private final short[] pIds = new short[]{-1, -1};

    public PinchToZoomGesture(NativeSurface nativeSurface, boolean bl) {
        this.clear(true);
        this.surface = nativeSurface;
        this.allowMorePointer = bl;
        this.zoom = 1.0f;
    }

    public String toString() {
        return "PinchZoom[1stTouch " + this.zoomFirstTouch + ", in " + this.isWithinGesture() + ", has " + (null != this.zoomEvent) + ", zoom " + this.zoom + "]";
    }

    private int gesturePointers(MouseEvent mouseEvent, int n2) {
        int n3 = 0;
        for (int i2 = mouseEvent.getPointerCount() - 1; i2 >= 0; --i2) {
            short s2;
            if (n2 == i2 || this.pIds[0] != (s2 = mouseEvent.getPointerId(i2)) && this.pIds[1] != s2) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    public void clear(boolean bl) {
        this.zoomEvent = null;
        if (bl) {
            this.zoomLastEdgeDist = 0;
            this.zoomFirstTouch = true;
            this.zoomMode = false;
            this.pIds[0] = -1;
            this.pIds[1] = -1;
        }
    }

    @Override
    public boolean isWithinGesture() {
        return this.zoomMode;
    }

    @Override
    public boolean hasGesture() {
        return null != this.zoomEvent;
    }

    @Override
    public InputEvent getGestureEvent() {
        return this.zoomEvent;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final void setZoom(float f2) {
        this.zoom = f2;
    }

    @Override
    public boolean process(InputEvent inputEvent) {
        if (null != this.zoomEvent || !(inputEvent instanceof MouseEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)inputEvent;
        int n2 = mouseEvent.getPointerCount();
        if (mouseEvent.getPointerType(0).getPointerClass() != MouseEvent.PointerClass.Onscreen || !this.allowMorePointer && n2 > 2) {
            return false;
        }
        short s2 = mouseEvent.getEventType();
        boolean bl = this.surface.getSurfaceWidth() >= this.surface.getSurfaceHeight();
        switch (s2) {
            case 203: {
                if (1 == n2) {
                    this.pIds[0] = mouseEvent.getPointerId(0);
                    this.pIds[1] = -1;
                } else if (2 <= n2) {
                    this.pIds[0] = mouseEvent.getPointerId(0);
                    this.pIds[1] = mouseEvent.getPointerId(1);
                }
                if (!DEBUG) break;
                System.err.println("XXX1: id0 " + this.pIds[0] + " -> idx0 " + 0 + ", id1 " + this.pIds[1] + " -> idx1 " + 1);
                System.err.println(this + ".pressed: down " + n2 + ", gPtr " + this.gesturePointers(mouseEvent, -1) + ", event " + mouseEvent);
                break;
            }
            case 204: {
                int n3 = this.gesturePointers(mouseEvent, 0);
                if (1 == n3) {
                    this.zoomFirstTouch = true;
                    this.zoomMode = false;
                } else if (0 == n3) {
                    this.clear(true);
                }
                if (!DEBUG) break;
                System.err.println(this + ".released: down " + n2 + ", gPtr " + n3 + ", event " + mouseEvent);
                break;
            }
            case 206: {
                if (2 > n2) break;
                int n4 = this.gesturePointers(mouseEvent, -1);
                if (2 == n4) {
                    int n5 = mouseEvent.getPointerIdx(this.pIds[0]);
                    int n6 = mouseEvent.getPointerIdx(this.pIds[1]);
                    if (0 <= n5 && 0 <= n6) {
                        int n7;
                        int n8 = bl ? mouseEvent.getY(n5) : mouseEvent.getX(n5);
                        int n9 = n7 = bl ? mouseEvent.getY(n6) : mouseEvent.getX(n6);
                        if (this.zoomFirstTouch) {
                            this.zoomLastEdgeDist = Math.abs(n8 - n7);
                            this.zoomFirstTouch = false;
                            this.zoomMode = true;
                        } else if (this.zoomMode) {
                            int n10 = Math.abs(n8 - n7);
                            int n11 = n10 - this.zoomLastEdgeDist;
                            float f2 = bl ? (float)this.surface.getSurfaceHeight() : (float)this.surface.getSurfaceWidth();
                            float f3 = (float)n11 / f2;
                            if (DEBUG) {
                                System.err.println("XXX2: id0 " + this.pIds[0] + " -> idx0 " + n5 + ", id1 " + this.pIds[1] + " -> idx1 " + n6);
                                System.err.println("XXX3: d " + n10 + ", ld " + this.zoomLastEdgeDist + ", dd " + n11 + ", screen " + f2 + " -> incr " + f3 + ", zoom " + this.zoom + " -> " + (this.zoom + f3));
                            }
                            this.zoom += f3;
                            if (2.0f < this.zoom) {
                                this.zoom = 2.0f;
                            } else if (0.0f > this.zoom) {
                                this.zoom = 0.0f;
                            }
                            this.zoomLastEdgeDist = n10;
                            this.zoomEvent = new ZoomEvent(mouseEvent.getSource(), mouseEvent.getWhen(), mouseEvent.getModifiers(), this, mouseEvent, this.zoom, f3, f2);
                        }
                    }
                }
                if (!DEBUG) break;
                System.err.println(this + ".dragged: down " + n2 + ", gPtr " + n4 + ", event " + mouseEvent);
                break;
            }
        }
        return null != this.zoomEvent;
    }

    public static class ZoomEvent
    extends GestureHandler.GestureEvent {
        private final float zoom;
        private final float delta;
        private final float scale;

        public ZoomEvent(Object object, long l2, int n2, GestureHandler gestureHandler, MouseEvent mouseEvent, float f2, float f3, float f4) {
            super(object, l2, n2, gestureHandler, mouseEvent);
            this.zoom = f2;
            this.delta = f3;
            this.scale = f4;
        }

        public final float getZoom() {
            return this.zoom;
        }

        public final float getDelta() {
            return this.delta;
        }

        public final float getScale() {
            return this.scale;
        }

        @Override
        public final String toString() {
            return "ZoomEvent[zoom " + this.zoom + ", delta " + this.delta + ", scale " + this.scale + ", trigger " + this.getTrigger() + ", handler " + this.getHandler() + "]";
        }
    }
}

