/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.util.EDTUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jogamp.newt.Debug;

public abstract class Display {
    public static final boolean DEBUG = Debug.debug("Display");
    protected static final boolean DEBUG_POINTER_ICON = Debug.debug("Display.PointerIcon");
    protected static final ArrayList<WeakReference<Display>> displayList = new ArrayList();
    protected static int displaysActive = 0;

    public abstract int hashCode();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Display) {
            Display display = (Display)object;
            return display.getFQName().equals(this.getFQName());
        }
        return false;
    }

    public abstract PixelFormat getNativePointerIconPixelFormat();

    public abstract boolean getNativePointerIconForceDirectNIO();

    public abstract PointerIcon createPointerIcon(IOUtil.ClassResources var1, int var2, int var3) throws IllegalArgumentException, IllegalStateException, IOException;

    public abstract PointerIcon createPointerIcon(PixelRectangle var1, int var2, int var3) throws IllegalArgumentException, IllegalStateException;

    public abstract void createNative() throws NativeWindowException;

    public abstract void destroy();

    public abstract boolean validateEDTStopped();

    public abstract boolean isNativeValid();

    public abstract int getReferenceCount();

    public abstract int addReference() throws NativeWindowException;

    public abstract int removeReference();

    public abstract AbstractGraphicsDevice getGraphicsDevice();

    public abstract long getHandle();

    public abstract String getFQName();

    public abstract int getId();

    public abstract String getName();

    public abstract String getType();

    public abstract boolean isExclusive();

    public abstract EDTUtil setEDTUtil(EDTUtil var1);

    public abstract EDTUtil getEDTUtil();

    public abstract boolean isEDTRunning();

    public abstract void dispatchMessages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDisplayList(String string) {
        ArrayList<WeakReference<Display>> arrayList = displayList;
        synchronized (arrayList) {
            System.err.println(string + " DisplayList[] entries: " + displayList.size() + " - " + Display.getThreadName());
            Iterator<WeakReference<Display>> iterator = displayList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Display display = (Display)iterator.next().get();
                System.err.println("  [" + n2 + "] : " + display + ", GC'ed " + (null == display));
                ++n2;
            }
        }
    }

    public static Display getFirstDisplayOf(String string, String string2, int n2, boolean bl) {
        return Display.getDisplayOfImpl(string, string2, n2, 1, bl);
    }

    public static Display getLastDisplayOf(String string, String string2, int n2, boolean bl) {
        return Display.getDisplayOfImpl(string, string2, n2, -1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Display getDisplayOfImpl(String string, String string2, int n2, int n3, boolean bl) {
        ArrayList<WeakReference<Display>> arrayList = displayList;
        synchronized (arrayList) {
            int n4;
            int n5 = n4 = n2 >= 0 ? n2 : displayList.size() - 1;
            while (n3 > 0 ? n4 < displayList.size() : n4 >= 0) {
                Display display = (Display)displayList.get(n4).get();
                if (null == display) {
                    displayList.remove(n4);
                    if (n3 >= 0) continue;
                    n4 += n3;
                    continue;
                }
                if (display.getType().equals(string) && display.getName().equals(string2) && (!bl || bl && !display.isExclusive())) {
                    return display;
                }
                n4 += n3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addDisplay2List(Display display) {
        ArrayList<WeakReference<Display>> arrayList = displayList;
        synchronized (arrayList) {
            int n2 = 0;
            while (n2 < displayList.size()) {
                if (null == displayList.get(n2).get()) {
                    displayList.remove(n2);
                    continue;
                }
                ++n2;
            }
            displayList.add(new WeakReference<Display>(display));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Display> getAllDisplays() {
        ArrayList<Display> arrayList;
        ArrayList<WeakReference<Display>> arrayList2 = displayList;
        synchronized (arrayList2) {
            arrayList = new ArrayList<Display>();
            int n2 = 0;
            while (n2 < displayList.size()) {
                Display display = (Display)displayList.get(n2).get();
                if (null == display) {
                    displayList.remove(n2);
                    continue;
                }
                arrayList.add((Display)displayList.get(n2).get());
                ++n2;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveDisplayNumber() {
        ArrayList<WeakReference<Display>> arrayList = displayList;
        synchronized (arrayList) {
            return displaysActive;
        }
    }

    public static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    public static String toHexString(long l2) {
        return "0x" + Long.toHexString(l2);
    }

    public static int hashCodeNullSafe(Object object) {
        return null != object ? object.hashCode() : 0;
    }

    public static interface PointerIcon
    extends PixelRectangle {
        @Override
        public int getStride();

        @Override
        public boolean isGLOriented();

        @Override
        public int hashCode();

        public Display getDisplay();

        public PointImmutable getHotspot();

        public boolean isValid();

        public void destroy();
    }
}

