/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.x11;

import com.jogamp.common.util.Bitfield;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import jogamp.nativewindow.x11.X11Capabilities;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XRenderDirectFormat;
import jogamp.nativewindow.x11.XRenderPictFormat;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11GraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    private XVisualInfo info;

    protected static XRenderDirectFormat XVisual2XRenderMask(long l2, long l3) {
        XRenderPictFormat xRenderPictFormat = XRenderPictFormat.create();
        return X11GraphicsConfiguration.XVisual2XRenderMask(l2, l3, xRenderPictFormat);
    }

    protected static XRenderDirectFormat XVisual2XRenderMask(long l2, long l3, XRenderPictFormat xRenderPictFormat) {
        if (!X11Lib.XRenderFindVisualFormat(l2, l3, xRenderPictFormat)) {
            return null;
        }
        return xRenderPictFormat.getDirect();
    }

    public static X11Capabilities XVisualInfo2X11Capabilities(X11GraphicsDevice x11GraphicsDevice, XVisualInfo xVisualInfo) {
        short s2;
        long l2 = x11GraphicsDevice.getHandle();
        X11Capabilities x11Capabilities = new X11Capabilities(xVisualInfo);
        XRenderDirectFormat xRenderDirectFormat = null != xVisualInfo ? X11GraphicsConfiguration.XVisual2XRenderMask(l2, xVisualInfo.getVisual()) : null;
        short s3 = s2 = null != xRenderDirectFormat ? xRenderDirectFormat.getAlphaMask() : (short)0;
        if (0 < s2) {
            x11Capabilities.setBackgroundOpaque(false);
            x11Capabilities.setTransparentRedValue(xRenderDirectFormat.getRedMask());
            x11Capabilities.setTransparentGreenValue(xRenderDirectFormat.getGreenMask());
            x11Capabilities.setTransparentBlueValue(xRenderDirectFormat.getBlueMask());
            x11Capabilities.setTransparentAlphaValue(s2);
        } else {
            x11Capabilities.setBackgroundOpaque(true);
        }
        x11Capabilities.setRedBits(Bitfield.Util.bitCount((int)xVisualInfo.getRed_mask()));
        x11Capabilities.setGreenBits(Bitfield.Util.bitCount((int)xVisualInfo.getGreen_mask()));
        x11Capabilities.setBlueBits(Bitfield.Util.bitCount((int)xVisualInfo.getBlue_mask()));
        x11Capabilities.setAlphaBits(Bitfield.Util.bitCount(s2));
        return x11Capabilities;
    }

    public X11GraphicsConfiguration(X11GraphicsScreen x11GraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, XVisualInfo xVisualInfo) {
        super(x11GraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2);
        this.info = xVisualInfo;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public final XVisualInfo getXVisualInfo() {
        return this.info;
    }

    protected final void setXVisualInfo(XVisualInfo xVisualInfo) {
        this.info = xVisualInfo;
    }

    public final int getXVisualID() {
        return null != this.info ? (int)this.info.getVisualid() : 0;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScreen() + ", visualID 0x" + Long.toHexString(this.getXVisualID()) + ",\n\tchosen    " + this.capabilitiesChosen + ",\n\trequested " + this.capabilitiesRequested + "]";
    }
}

