/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.DimensionImmutable;

public class SurfaceSize
implements Comparable<SurfaceSize> {
    final DimensionImmutable resolution;
    final int bitsPerPixel;

    public SurfaceSize(DimensionImmutable dimensionImmutable, int n2) {
        if (null == dimensionImmutable || n2 <= 0) {
            throw new IllegalArgumentException("resolution must be set and bitsPerPixel greater 0");
        }
        this.resolution = dimensionImmutable;
        this.bitsPerPixel = n2;
    }

    public final DimensionImmutable getResolution() {
        return this.resolution;
    }

    public final int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public final String toString() {
        return "[ " + this.resolution + " pixels x " + this.bitsPerPixel + " bpp ]";
    }

    @Override
    public int compareTo(SurfaceSize surfaceSize) {
        int n2 = this.resolution.compareTo(surfaceSize.getResolution());
        if (0 != n2) {
            return n2;
        }
        int n3 = surfaceSize.getBitsPerPixel();
        if (this.bitsPerPixel > n3) {
            return 1;
        }
        if (this.bitsPerPixel < n3) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SurfaceSize) {
            SurfaceSize surfaceSize = (SurfaceSize)object;
            return this.getResolution().equals(surfaceSize.getResolution()) && this.getBitsPerPixel() == surfaceSize.getBitsPerPixel();
        }
        return false;
    }

    public final int hashCode() {
        int n2 = this.getResolution().hashCode();
        n2 = (n2 << 5) - n2 + this.getBitsPerPixel();
        return n2;
    }
}

