/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.DefaultGraphicsConfigurationFactoryImpl;

public abstract class GraphicsConfigurationFactory {
    protected static final boolean DEBUG;
    private static final Map<DeviceCapsType, GraphicsConfigurationFactory> registeredFactories;
    private static final DeviceCapsType defaultDeviceCapsType;
    static boolean initialized;

    public static synchronized void initSingleton() {
        if (!initialized) {
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - GraphicsConfigurationFactory.initSingleton()");
            }
            GraphicsConfigurationFactory.registerFactory(GraphicsConfigurationFactory.defaultDeviceCapsType.deviceType, GraphicsConfigurationFactory.defaultDeviceCapsType.capsType, new DefaultGraphicsConfigurationFactoryImpl());
            if (".x11" == NativeWindowFactory.getNativeWindowType(true)) {
                try {
                    ReflectionUtil.callStaticMethod("jogamp.nativewindow.x11.X11GraphicsConfigurationFactory", "registerFactory", null, null, GraphicsConfigurationFactory.class.getClassLoader());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (NativeWindowFactory.isAWTAvailable()) {
                    try {
                        ReflectionUtil.callStaticMethod("jogamp.nativewindow.x11.awt.X11AWTGraphicsConfigurationFactory", "registerFactory", null, null, GraphicsConfigurationFactory.class.getClassLoader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static synchronized void shutdown() {
        if (initialized) {
            initialized = false;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - GraphicsConfigurationFactory.shutdown()");
            }
            registeredFactories.clear();
        }
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    protected static String toHexString(long l2) {
        return "0x" + Long.toHexString(l2);
    }

    protected GraphicsConfigurationFactory() {
    }

    public static GraphicsConfigurationFactory getFactory(AbstractGraphicsDevice abstractGraphicsDevice, CapabilitiesImmutable capabilitiesImmutable) {
        if (abstractGraphicsDevice == null) {
            throw new IllegalArgumentException("null device");
        }
        if (capabilitiesImmutable == null) {
            throw new IllegalArgumentException("null caps");
        }
        return GraphicsConfigurationFactory.getFactory(abstractGraphicsDevice.getClass(), capabilitiesImmutable.getClass());
    }

    public static GraphicsConfigurationFactory getFactory(Class<?> clazz, Class<?> clazz2) throws IllegalArgumentException, NativeWindowException {
        if (!GraphicsConfigurationFactory.defaultDeviceCapsType.deviceType.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given class must implement AbstractGraphicsDevice");
        }
        if (!GraphicsConfigurationFactory.defaultDeviceCapsType.capsType.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Given capabilities class must implement CapabilitiesImmutable");
        }
        if (DEBUG) {
            ExceptionUtils.dumpStack(System.err);
            System.err.println("GraphicsConfigurationFactory.getFactory: " + clazz.getName() + ", " + clazz2.getName());
            GraphicsConfigurationFactory.dumpFactories();
        }
        ArrayList<Class<?>> arrayList = GraphicsConfigurationFactory.getAllAssignableClassesFrom(GraphicsConfigurationFactory.defaultDeviceCapsType.deviceType, clazz, false);
        if (DEBUG) {
            System.err.println("GraphicsConfigurationFactory.getFactory() deviceTypes: " + arrayList);
        }
        ArrayList<Class<?>> arrayList2 = GraphicsConfigurationFactory.getAllAssignableClassesFrom(GraphicsConfigurationFactory.defaultDeviceCapsType.capsType, clazz2, true);
        if (DEBUG) {
            System.err.println("GraphicsConfigurationFactory.getFactory() capabilitiesTypes: " + arrayList2);
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Class clazz3 = (Class)arrayList.get(i2);
            for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                Class clazz4 = (Class)arrayList2.get(i3);
                DeviceCapsType deviceCapsType = new DeviceCapsType(clazz3, clazz4);
                GraphicsConfigurationFactory graphicsConfigurationFactory = registeredFactories.get(deviceCapsType);
                if (graphicsConfigurationFactory == null) continue;
                if (DEBUG) {
                    System.err.println("GraphicsConfigurationFactory.getFactory() found " + deviceCapsType + " -> " + graphicsConfigurationFactory);
                }
                return graphicsConfigurationFactory;
            }
        }
        GraphicsConfigurationFactory graphicsConfigurationFactory = registeredFactories.get(defaultDeviceCapsType);
        if (DEBUG) {
            System.err.println("GraphicsConfigurationFactory.getFactory() DEFAULT " + defaultDeviceCapsType + " -> " + graphicsConfigurationFactory);
        }
        return graphicsConfigurationFactory;
    }

    private static ArrayList<Class<?>> getAllAssignableClassesFrom(Class<?> clazz, Class<?> clazz2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList.add(clazz2);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Class clazz3 = (Class)arrayList.get(i2);
            GraphicsConfigurationFactory.getAllAssignableClassesFrom(clazz, clazz3, bl, arrayList2, arrayList);
        }
        return arrayList2;
    }

    private static void getAllAssignableClassesFrom(Class<?> clazz, Class<?> clazz2, boolean bl, List<Class<?>> list, List<Class<?>> list2) {
        ArrayList arrayList = new ArrayList();
        if (clazz.isAssignableFrom(clazz2) && !list.contains(clazz2) && (!bl || clazz2.isInterface())) {
            arrayList.add(clazz2);
        }
        arrayList.addAll(Arrays.asList(clazz2.getInterfaces()));
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Class clazz3 = (Class)arrayList.get(i2);
            if (!clazz.isAssignableFrom(clazz3) || list.contains(clazz3)) continue;
            list.add(clazz3);
            if (clazz.equals(clazz3) || list2.contains(clazz3)) continue;
            list2.add(clazz3);
        }
        Class<?> clazz4 = clazz2.getSuperclass();
        if (null != clazz4 && clazz.isAssignableFrom(clazz4) && !list2.contains(clazz4)) {
            list2.add(clazz4);
        }
    }

    private static void dumpFactories() {
        Set<DeviceCapsType> set = registeredFactories.keySet();
        int n2 = 0;
        for (DeviceCapsType deviceCapsType : set) {
            System.err.println("Factory #" + n2 + ": " + deviceCapsType + " -> " + registeredFactories.get(deviceCapsType));
            ++n2;
        }
    }

    protected static GraphicsConfigurationFactory registerFactory(Class<?> clazz, Class<?> clazz2, GraphicsConfigurationFactory graphicsConfigurationFactory) throws IllegalArgumentException {
        GraphicsConfigurationFactory graphicsConfigurationFactory2;
        if (!GraphicsConfigurationFactory.defaultDeviceCapsType.deviceType.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given device class must implement AbstractGraphicsDevice");
        }
        if (!GraphicsConfigurationFactory.defaultDeviceCapsType.capsType.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Given capabilities class must implement CapabilitiesImmutable");
        }
        DeviceCapsType deviceCapsType = new DeviceCapsType(clazz, clazz2);
        if (null == graphicsConfigurationFactory) {
            graphicsConfigurationFactory2 = registeredFactories.remove(deviceCapsType);
            if (DEBUG) {
                System.err.println("GraphicsConfigurationFactory.registerFactory() remove " + deviceCapsType + ", deleting: " + graphicsConfigurationFactory2);
            }
        } else {
            graphicsConfigurationFactory2 = registeredFactories.put(deviceCapsType, graphicsConfigurationFactory);
            if (DEBUG) {
                System.err.println("GraphicsConfigurationFactory.registerFactory() put " + deviceCapsType + " -> " + graphicsConfigurationFactory + ", overridding: " + graphicsConfigurationFactory2);
            }
        }
        return graphicsConfigurationFactory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractGraphicsConfiguration chooseGraphicsConfiguration(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n2) throws IllegalArgumentException, NativeWindowException {
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Chosen Capabilities are null");
        }
        if (null == capabilitiesImmutable2) {
            throw new NativeWindowException("Requested Capabilities are null");
        }
        if (null == abstractGraphicsScreen) {
            throw new NativeWindowException("Screen is null");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice) {
            throw new NativeWindowException("Screen's Device is null");
        }
        abstractGraphicsDevice.lock();
        try {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.chooseGraphicsConfigurationImpl(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen, n2);
            return abstractGraphicsConfiguration;
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    protected abstract AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable var1, CapabilitiesImmutable var2, CapabilitiesChooser var3, AbstractGraphicsScreen var4, int var5) throws IllegalArgumentException, NativeWindowException;

    static {
        initialized = false;
        DEBUG = Debug.debug("GraphicsConfiguration");
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: GraphicsConfigurationFactory.<init>");
        }
        registeredFactories = Collections.synchronizedMap(new HashMap());
        defaultDeviceCapsType = new DeviceCapsType(AbstractGraphicsDevice.class, CapabilitiesImmutable.class);
    }

    private static class DeviceCapsType {
        public final Class<?> deviceType;
        public final Class<?> capsType;
        private final int hash32;

        public DeviceCapsType(Class<?> clazz, Class<?> clazz2) {
            this.deviceType = clazz;
            this.capsType = clazz2;
            int n2 = 31 + clazz.hashCode();
            this.hash32 = n2 = (n2 << 5) - n2 + clazz2.hashCode();
        }

        public final int hashCode() {
            return this.hash32;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DeviceCapsType) {
                DeviceCapsType deviceCapsType = (DeviceCapsType)object;
                return this.deviceType == deviceCapsType.deviceType && this.capsType == deviceCapsType.capsType;
            }
            return false;
        }

        public final String toString() {
            return "DeviceCapsType[" + this.deviceType.getName() + ", " + this.capsType.getName() + "]";
        }
    }
}

