/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import java.util.ArrayList;
import java.util.HashMap;
import jogamp.graph.geom.plane.AffineTransform;

public class TextRegionUtil {
    public final int renderModes;
    public static final int DEFAULT_CACHE_LIMIT = 256;
    public final AffineTransform tempT1 = new AffineTransform();
    public final AffineTransform tempT2 = new AffineTransform();
    private final HashMap<String, GLRegion> stringCacheMap = new HashMap(256);
    private final ArrayList<String> stringCacheArray = new ArrayList(256);
    private int stringCacheLimit = 256;

    public TextRegionUtil(int n2) {
        this.renderModes = n2;
    }

    public static int getCharCount(String string, char c2) {
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != c2) continue;
            ++n3;
        }
        return n3;
    }

    public static void processString(ShapeVisitor shapeVisitor, AffineTransform affineTransform, Font font, float f2, CharSequence charSequence, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        int n2 = charSequence.length();
        Font.Metrics metrics = font.getMetrics();
        float f3 = font.getLineHeight(f2);
        float f4 = metrics.getScale(f2);
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if ('\n' == c2) {
                f5 -= f3;
                f6 = 0.0f;
                continue;
            }
            if (c2 == ' ') {
                f6 += font.getAdvanceWidth(3, f2);
                continue;
            }
            if (Region.DEBUG_INSTANCE) {
                System.err.println("XXXXXXXXXXXXXXx char: " + c2 + ", scale: " + f4 + "; translate: " + f6 + ", " + f5);
            }
            if (null != affineTransform) {
                affineTransform2.setTransform(affineTransform);
            } else {
                affineTransform2.setToIdentity();
            }
            affineTransform2.translate(f6, f5, affineTransform3);
            affineTransform2.scale(f4, f4, affineTransform3);
            Font.Glyph glyph = font.getGlyph(c2);
            OutlineShape outlineShape = glyph.getShape();
            if (null == outlineShape) continue;
            shapeVisitor.visit(outlineShape, affineTransform2);
            f6 += glyph.getAdvance(f2, true);
        }
    }

    public static void addStringToRegion(final GLRegion gLRegion, Vertex.Factory<? extends Vertex> factory, Font font, float f2, CharSequence charSequence, final float[] fArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(){

            @Override
            public final void visit(OutlineShape outlineShape, AffineTransform affineTransform) {
                gLRegion.addOutlineShape(outlineShape, affineTransform, gLRegion.hasColorChannel() ? fArray : null);
            }
        };
        TextRegionUtil.processString(shapeVisitor, null, font, f2, charSequence, affineTransform, affineTransform2);
    }

    public void drawString3D(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Font font, float f2, CharSequence charSequence, float[] fArray, int[] nArray) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        GLRegion gLRegion = this.getCachedRegion(font, charSequence, f2, 0);
        if (null == gLRegion) {
            gLRegion = GLRegion.create(this.renderModes, null);
            TextRegionUtil.addStringToRegion(gLRegion, regionRenderer.getRenderState().getVertexFactory(), font, f2, charSequence, fArray, this.tempT1, this.tempT2);
            this.addCachedRegion(gL2ES2, font, charSequence, f2, 0, gLRegion);
        }
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
    }

    public static void drawString3D(GL2ES2 gL2ES2, int n2, RegionRenderer regionRenderer, Font font, float f2, CharSequence charSequence, float[] fArray, int[] nArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        GLRegion gLRegion = GLRegion.create(n2, null);
        TextRegionUtil.addStringToRegion(gLRegion, regionRenderer.getRenderState().getVertexFactory(), font, f2, charSequence, fArray, affineTransform, affineTransform2);
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
        gLRegion.destroy(gL2ES2);
    }

    public static void drawString3D(GL2ES2 gL2ES2, GLRegion gLRegion, RegionRenderer regionRenderer, Font font, float f2, CharSequence charSequence, float[] fArray, int[] nArray, AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (!regionRenderer.isInitialized()) {
            throw new GLException("TextRendererImpl01: not initialized!");
        }
        gLRegion.clear(gL2ES2);
        TextRegionUtil.addStringToRegion(gLRegion, regionRenderer.getRenderState().getVertexFactory(), font, f2, charSequence, fArray, affineTransform, affineTransform2);
        gLRegion.draw(gL2ES2, regionRenderer, nArray);
    }

    public void clear(GL2ES2 gL2ES2) {
        for (GLRegion gLRegion : this.stringCacheMap.values()) {
            gLRegion.destroy(gL2ES2);
        }
        this.stringCacheMap.clear();
        this.stringCacheArray.clear();
    }

    public final void setCacheLimit(int n2) {
        this.stringCacheLimit = n2;
    }

    public final void setCacheLimit(GL2ES2 gL2ES2, int n2) {
        this.stringCacheLimit = n2;
        this.validateCache(gL2ES2, 0);
    }

    public final int getCacheLimit() {
        return this.stringCacheLimit;
    }

    public final int getCacheSize() {
        return this.stringCacheArray.size();
    }

    protected final void validateCache(GL2ES2 gL2ES2, int n2) {
        if (this.getCacheLimit() > 0) {
            while (this.getCacheSize() + n2 > this.getCacheLimit()) {
                this.removeCachedRegion(gL2ES2, 0);
            }
        }
    }

    protected final GLRegion getCachedRegion(Font font, CharSequence charSequence, float f2, int n2) {
        return this.stringCacheMap.get(this.getKey(font, charSequence, f2, n2));
    }

    protected final void addCachedRegion(GL2ES2 gL2ES2, Font font, CharSequence charSequence, float f2, int n2, GLRegion gLRegion) {
        String string;
        GLRegion gLRegion2;
        if (0 != this.getCacheLimit() && null == (gLRegion2 = this.stringCacheMap.put(string = this.getKey(font, charSequence, f2, n2), gLRegion))) {
            this.validateCache(gL2ES2, 1);
            this.stringCacheArray.add(this.stringCacheArray.size(), string);
        }
    }

    protected final void removeCachedRegion(GL2ES2 gL2ES2, Font font, CharSequence charSequence, int n2, int n3) {
        String string = this.getKey(font, charSequence, n2, n3);
        GLRegion gLRegion = this.stringCacheMap.remove(string);
        if (null != gLRegion) {
            gLRegion.destroy(gL2ES2);
        }
        this.stringCacheArray.remove(string);
    }

    protected final void removeCachedRegion(GL2ES2 gL2ES2, int n2) {
        GLRegion gLRegion;
        String string = this.stringCacheArray.remove(n2);
        if (null != string && null != (gLRegion = this.stringCacheMap.remove(string))) {
            gLRegion.destroy(gL2ES2);
        }
    }

    protected final String getKey(Font font, CharSequence charSequence, float f2, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        return font.getName(stringBuilder, 3).append(".").append(charSequence.hashCode()).append(".").append(Float.floatToIntBits(f2)).append(n2).toString();
    }

    public static interface ShapeVisitor {
        public void visit(OutlineShape var1, AffineTransform var2);
    }
}

