/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.util.Iterator;
import jogamp.graph.curve.opengl.shader.AttributeNames;

public class RegionRenderer {
    protected static final boolean DEBUG = Region.DEBUG;
    protected static final boolean DEBUG_INSTANCE = Region.DEBUG_INSTANCE;
    public static final GLCallback defaultBlendEnable = new GLCallback(){

        @Override
        public void run(GL gL, RegionRenderer regionRenderer) {
            if (regionRenderer.rs.isHintMaskSet(2)) {
                gL.glDepthMask(false);
            }
            gL.glEnable(3042);
            gL.glBlendEquation(32774);
            regionRenderer.rs.setHintMask(1);
        }
    };
    public static final GLCallback defaultBlendDisable = new GLCallback(){

        @Override
        public void run(GL gL, RegionRenderer regionRenderer) {
            regionRenderer.rs.clearHintMask(1);
            gL.glDisable(3042);
            if (regionRenderer.rs.isHintMaskSet(2)) {
                gL.glDepthMask(true);
            }
        }
    };
    private final RenderState rs;
    private final GLCallback enableCallback;
    private final GLCallback disableCallback;
    private int vp_width;
    private int vp_height;
    private boolean initialized;
    private boolean vboSupported = false;
    private static final String SHADER_SRC_SUB = "";
    private static final String SHADER_BIN_SUB = "bin";
    private static String GLSL_USE_COLOR_CHANNEL = "#define USE_COLOR_CHANNEL 1\n";
    private static String GLSL_USE_COLOR_TEXTURE = "#define USE_COLOR_TEXTURE 1\n";
    private static String GLSL_DEF_SAMPLE_COUNT = "#define SAMPLE_COUNT ";
    private static String GLSL_CONST_SAMPLE_COUNT = "const float sample_count = ";
    private static String GLSL_MAIN_BEGIN = "void main (void)\n{\n";
    private static final String gcuTexture2D = "gcuTexture2D";
    private static final String es2_precision_fp = "\nprecision mediump float;\nprecision mediump int;\nprecision mediump sampler2D;\n";
    private final IntObjectHashMap shaderPrograms = new IntObjectHashMap();
    private static final int HIGH_MASK = 1536;
    private static final int TWO_PASS_BIT = Integer.MIN_VALUE;

    public static RegionRenderer create(RenderState renderState, GLCallback gLCallback, GLCallback gLCallback2) {
        return new RegionRenderer(renderState, gLCallback, gLCallback2);
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final int getWidth() {
        return this.vp_width;
    }

    public final int getHeight() {
        return this.vp_height;
    }

    public final PMVMatrix getMatrix() {
        return this.rs.getMatrix();
    }

    protected RegionRenderer(RenderState renderState, GLCallback gLCallback, GLCallback gLCallback2) {
        this.rs = renderState;
        this.enableCallback = gLCallback;
        this.disableCallback = gLCallback2;
    }

    public final boolean isVBOSupported() {
        return this.vboSupported;
    }

    public final void init(GL2ES2 gL2ES2, int n2) throws GLException {
        if (this.initialized) {
            return;
        }
        boolean bl = this.vboSupported = gL2ES2.isFunctionAvailable("glGenBuffers") && gL2ES2.isFunctionAvailable("glBindBuffer") && gL2ES2.isFunctionAvailable("glBufferData") && gL2ES2.isFunctionAvailable("glDrawElements") && gL2ES2.isFunctionAvailable("glVertexAttribPointer") && gL2ES2.isFunctionAvailable("glDeleteBuffers");
        if (DEBUG) {
            System.err.println("TextRendererImpl01: VBO Supported = " + this.isVBOSupported());
        }
        if (!this.vboSupported) {
            throw new GLException("VBO not supported");
        }
        this.rs.attachTo(gL2ES2);
        if (null != this.enableCallback) {
            this.enableCallback.run(gL2ES2, this);
        }
        this.initialized = true;
    }

    public final void destroy(GL2ES2 gL2ES2) {
        if (!this.initialized) {
            if (DEBUG_INSTANCE) {
                System.err.println("TextRenderer: Not initialized!");
            }
            return;
        }
        Iterator<IntObjectHashMap.Entry> iterator = this.shaderPrograms.iterator();
        while (iterator.hasNext()) {
            ShaderProgram shaderProgram = (ShaderProgram)iterator.next().getValue();
            shaderProgram.destroy(gL2ES2);
        }
        this.shaderPrograms.clear();
        this.rs.destroy(gL2ES2);
        this.initialized = false;
    }

    public final RenderState getRenderState() {
        return this.rs;
    }

    public final void enable(GL2ES2 gL2ES2, boolean bl) {
        ShaderProgram shaderProgram;
        if (bl) {
            if (null != this.enableCallback) {
                this.enableCallback.run(gL2ES2, this);
            }
        } else if (null != this.disableCallback) {
            this.disableCallback.run(gL2ES2, this);
        }
        if (!bl && null != (shaderProgram = this.rs.getShaderProgram())) {
            shaderProgram.useProgram(gL2ES2, false);
        }
    }

    public final void reshapeNotify(int n2, int n3) {
        this.vp_width = n2;
        this.vp_height = n3;
    }

    public final void reshapePerspective(float f2, int n2, int n3, float f3, float f4) {
        this.vp_width = n2;
        this.vp_height = n3;
        float f5 = (float)n2 / (float)n3;
        PMVMatrix pMVMatrix = this.rs.getMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(f2, f5, f3, f4);
    }

    public final void reshapeOrtho(int n2, int n3, float f2, float f3) {
        this.vp_width = n2;
        this.vp_height = n3;
        PMVMatrix pMVMatrix = this.rs.getMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glOrthof(0.0f, n2, 0.0f, n3, f2, f3);
    }

    private String getVersionedShaderName() {
        return "curverenderer01";
    }

    private final String getFragmentShaderPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGLES()) {
            return es2_precision_fp;
        }
        if (ShaderCode.requiresGL3DefaultPrecision(gL2ES2)) {
            return "\nprecision highp float;\nprecision mediump int;\n/*precision mediump sampler2D;*/\n";
        }
        return null;
    }

    public final boolean useShaderProgram(GL2ES2 gL2ES2, int n2, boolean bl, int n3, int n4, TextureSequence textureSequence) {
        String string;
        int n5;
        int n6 = null != textureSequence ? textureSequence.getTextureFragmentShaderHashCode() : 0;
        ShaderModeSelector1 shaderModeSelector1 = bl ? ShaderModeSelector1.selectPass1(n2) : ShaderModeSelector1.selectPass2(n2, n3, n4);
        boolean bl2 = Region.isTwoPass(n2);
        boolean bl3 = bl && null != textureSequence;
        int n7 = (n6 << 5) - n6 + (shaderModeSelector1.ordinal() | 0x600 & n2 | (bl2 ? Integer.MIN_VALUE : 0));
        ShaderProgram shaderProgram = (ShaderProgram)this.shaderPrograms.get(n7);
        if (null != shaderProgram) {
            boolean bl4 = this.getRenderState().setShaderProgram(gL2ES2, shaderProgram);
            if (DEBUG) {
                if (bl4) {
                    System.err.printf("RegionRendererImpl01.useShaderProgram.X1: GOT renderModes %s, sel1 %s, key 0x%X -> sp %d / %d (changed)%n", new Object[]{Region.getRenderModeString(n2), shaderModeSelector1, n7, shaderProgram.program(), shaderProgram.id()});
                } else {
                    System.err.printf("RegionRendererImpl01.useShaderProgram.X1: GOT renderModes %s, sel1 %s, key 0x%X -> sp %d / %d (keep)%n", new Object[]{Region.getRenderModeString(n2), shaderModeSelector1, n7, shaderProgram.program(), shaderProgram.id()});
                }
            }
            return bl4;
        }
        String string2 = this.getVersionedShaderName();
        String string3 = bl2 ? string2 + "-pass" + (bl ? 1 : 2) : string2 + "-single";
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, AttributeNames.class, SHADER_SRC_SUB, SHADER_BIN_SUB, string3, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, AttributeNames.class, SHADER_SRC_SUB, SHADER_BIN_SUB, string2 + "-segment-head", true);
        if (bl3 && 36197 == textureSequence.getTextureTarget() && !gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
            throw new GLException("GL_OES_EGL_image_external requested but not available");
        }
        boolean bl5 = false;
        if (bl3 && 36197 == textureSequence.getTextureTarget() && Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
            bl5 = true;
        }
        int n8 = shaderCode.defaultShaderCustomization(gL2ES2, !bl5, true);
        int n9 = n5 = bl5 ? 0 : shaderCode2.addGLSLVersion(gL2ES2);
        if (bl3) {
            n5 = shaderCode2.insertShaderSource(0, n5, textureSequence.getRequiredExtensionsShaderStub());
        }
        if (bl && bl5 || gL2ES2.isGLES2() && !gL2ES2.isGLES3()) {
            n5 = shaderCode2.insertShaderSource(0, n5, ShaderCode.createExtensionDirective("GL_OES_standard_derivatives", "enable"));
        }
        n5 = shaderCode2.addDefaultShaderPrecision(gL2ES2, n5);
        n5 = -1;
        if (Region.hasColorChannel(n2)) {
            n8 = shaderCode.insertShaderSource(0, n8, GLSL_USE_COLOR_CHANNEL);
            n5 = shaderCode2.insertShaderSource(0, n5, GLSL_USE_COLOR_CHANNEL);
        }
        if (Region.hasColorTexture(n2)) {
            shaderCode.insertShaderSource(0, n8, GLSL_USE_COLOR_TEXTURE);
            n5 = shaderCode2.insertShaderSource(0, n5, GLSL_USE_COLOR_TEXTURE);
        }
        if (!bl) {
            n5 = shaderCode2.insertShaderSource(0, n5, GLSL_DEF_SAMPLE_COUNT + shaderModeSelector1.sampleCount + "\n");
            n5 = shaderCode2.insertShaderSource(0, n5, GLSL_CONST_SAMPLE_COUNT + shaderModeSelector1.sampleCount + ".0;\n");
        }
        try {
            n5 = shaderCode2.insertShaderSource(0, n5, AttributeNames.class, "uniforms.glsl");
            n5 = shaderCode2.insertShaderSource(0, n5, AttributeNames.class, "varyings.glsl");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read: includes", iOException);
        }
        if (0 > n5) {
            throw new RuntimeException("Failed to read: includes");
        }
        if (bl3) {
            n5 = shaderCode2.insertShaderSource(0, n5, "uniform " + textureSequence.getTextureSampler2DType() + " " + "gcu_ColorTexUnit" + ";\n");
            string = textureSequence.getTextureLookupFunctionName(gcuTexture2D);
            n5 = shaderCode2.insertShaderSource(0, n5, textureSequence.getTextureLookupFragmentShaderImpl());
        } else {
            string = null;
        }
        n5 = shaderCode2.insertShaderSource(0, n5, GLSL_MAIN_BEGIN);
        String string4 = bl ? "-pass1-" : "-pass2-";
        String string5 = string2 + string4 + shaderModeSelector1.tech + shaderModeSelector1.sub + ".glsl";
        if (DEBUG) {
            System.err.printf("RegionRendererImpl01.useShaderProgram.1: segment %s%n", string5);
        }
        try {
            n5 = shaderCode2.insertShaderSource(0, n5, AttributeNames.class, string5);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read: " + string5, iOException);
        }
        if (0 > n5) {
            throw new RuntimeException("Failed to read: " + string5);
        }
        n5 = shaderCode2.insertShaderSource(0, n5, "}\n");
        if (bl3) {
            shaderCode2.replaceInShaderSource(gcuTexture2D, string);
        }
        shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.init(gL2ES2)) {
            throw new GLException("RegionRenderer: Couldn't init program: " + shaderProgram);
        }
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("could not link program: " + shaderProgram);
        }
        this.getRenderState().setShaderProgram(gL2ES2, shaderProgram);
        this.shaderPrograms.put(n7, shaderProgram);
        if (DEBUG) {
            System.err.printf("RegionRendererImpl01.useShaderProgram.X1: PUT renderModes %s, sel1 %s, key 0x%X -> sp %d / %d (changed)%n", new Object[]{Region.getRenderModeString(n2), shaderModeSelector1, n7, shaderProgram.program(), shaderProgram.id()});
        }
        return true;
    }

    private static enum ShaderModeSelector1 {
        PASS1_SIMPLE("curve", "_simple", 0),
        PASS1_WEIGHT("curve", "_weight", 0),
        PASS2_MSAA("msaa", "", 0),
        PASS2_VBAA_QUAL0_SAMPLES1("vbaa", "_flipquad3", 1),
        PASS2_VBAA_QUAL0_SAMPLES2("vbaa", "_flipquad3", 2),
        PASS2_VBAA_QUAL0_SAMPLES4("vbaa", "_flipquad3", 4),
        PASS2_VBAA_QUAL0_SAMPLES8("vbaa", "_flipquad3", 8),
        PASS2_VBAA_QUAL1_SAMPLES1("vbaa", "_bforce_odd", 1),
        PASS2_VBAA_QUAL1_SAMPLES2("vbaa", "_bforce_even", 2),
        PASS2_VBAA_QUAL1_SAMPLES3("vbaa", "_bforce_odd", 3),
        PASS2_VBAA_QUAL1_SAMPLES4("vbaa", "_bforce_even", 4),
        PASS2_VBAA_QUAL1_SAMPLES5("vbaa", "_bforce_odd", 5),
        PASS2_VBAA_QUAL1_SAMPLES6("vbaa", "_bforce_even", 6),
        PASS2_VBAA_QUAL1_SAMPLES7("vbaa", "_bforce_odd", 7),
        PASS2_VBAA_QUAL1_SAMPLES8("vbaa", "_bforce_even", 8);

        public final String tech;
        public final String sub;
        public final int sampleCount;

        private ShaderModeSelector1(String string2, String string3, int n3) {
            this.tech = string2;
            this.sub = string3;
            this.sampleCount = n3;
        }

        public static ShaderModeSelector1 selectPass1(int n2) {
            return Region.hasVariableWeight(n2) ? PASS1_WEIGHT : PASS1_SIMPLE;
        }

        public static ShaderModeSelector1 selectPass2(int n2, int n3, int n4) {
            if (Region.isMSAA(n2)) {
                return PASS2_MSAA;
            }
            if (Region.isVBAA(n2)) {
                if (0 == n3) {
                    if (n4 < 2) {
                        return PASS2_VBAA_QUAL0_SAMPLES1;
                    }
                    if (n4 < 4) {
                        return PASS2_VBAA_QUAL0_SAMPLES2;
                    }
                    if (n4 < 8) {
                        return PASS2_VBAA_QUAL0_SAMPLES4;
                    }
                    return PASS2_VBAA_QUAL0_SAMPLES8;
                }
                switch (n4) {
                    case 0: 
                    case 1: {
                        return PASS2_VBAA_QUAL1_SAMPLES1;
                    }
                    case 2: {
                        return PASS2_VBAA_QUAL1_SAMPLES2;
                    }
                    case 3: {
                        return PASS2_VBAA_QUAL1_SAMPLES3;
                    }
                    case 4: {
                        return PASS2_VBAA_QUAL1_SAMPLES4;
                    }
                    case 5: {
                        return PASS2_VBAA_QUAL1_SAMPLES5;
                    }
                    case 6: {
                        return PASS2_VBAA_QUAL1_SAMPLES6;
                    }
                    case 7: {
                        return PASS2_VBAA_QUAL1_SAMPLES7;
                    }
                }
                return PASS2_VBAA_QUAL1_SAMPLES8;
            }
            return null;
        }
    }

    public static interface GLCallback {
        public void run(GL var1, RegionRenderer var2);
    }
}

