/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.texture.TextureSequence;
import jogamp.graph.curve.opengl.VBORegion2PMSAAES2;
import jogamp.graph.curve.opengl.VBORegion2PVBAAES2;
import jogamp.graph.curve.opengl.VBORegionSPES2;

public abstract class GLRegion
extends Region {
    protected final TextureSequence colorTexSeq;

    public static GLRegion create(int n2, TextureSequence textureSequence) {
        if (null != textureSequence) {
            n2 |= 0x400;
        } else if (Region.hasColorTexture(n2)) {
            throw new IllegalArgumentException("COLORTEXTURE_RENDERING_BIT set but null TextureSequence");
        }
        if (GLRegion.isVBAA(n2)) {
            return new VBORegion2PVBAAES2(n2, textureSequence, 0);
        }
        if (GLRegion.isMSAA(n2)) {
            return new VBORegion2PMSAAES2(n2, textureSequence, 0);
        }
        return new VBORegionSPES2(n2, textureSequence);
    }

    protected GLRegion(int n2, TextureSequence textureSequence) {
        super(n2);
        this.colorTexSeq = textureSequence;
    }

    protected abstract void updateImpl(GL2ES2 var1);

    protected abstract void destroyImpl(GL2ES2 var1);

    protected abstract void clearImpl(GL2ES2 var1);

    public void clear(GL2ES2 gL2ES2) {
        this.clearImpl(gL2ES2);
        this.clearImpl();
    }

    public final void destroy(GL2ES2 gL2ES2) {
        this.clear(gL2ES2);
        this.destroyImpl(gL2ES2);
    }

    public final void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        if (this.isShapeDirty()) {
            this.updateImpl(gL2ES2);
        }
        this.drawImpl(gL2ES2, regionRenderer, nArray);
        this.clearDirtyBits(3);
    }

    protected abstract void drawImpl(GL2ES2 var1, RegionRenderer var2, int[] var3);
}

