/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.Bitfield;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private final Map<IdentityWeakReference<K>, V> backingStore;

    public WeakIdentityHashMap() {
        this.backingStore = new HashMap<IdentityWeakReference<K>, V>();
    }

    public WeakIdentityHashMap(int n2, float f2) {
        this.backingStore = new HashMap<IdentityWeakReference<K>, V>(n2, f2);
    }

    public static WeakIdentityHashMap<?, ?> createWithRequiredSize(int n2, float f2) {
        float[] fArray = new float[]{f2};
        int n3 = WeakIdentityHashMap.capacityForRequiredSize(n2, fArray);
        return new WeakIdentityHashMap(n3, fArray[0]);
    }

    public static int capacityForRequiredSize(int n2, float[] fArray) {
        if (n2 >= 0x40000000) {
            return Integer.MAX_VALUE;
        }
        float f2 = fArray[0];
        int n3 = (int)((float)n2 / f2 + 1.0f);
        if (!Bitfield.Util.isPowerOf2(n3) || 0.86f <= f2) {
            return n3;
        }
        while (Bitfield.Util.isPowerOf2(n3 = (int)((float)n2 / (f2 += 0.01f) + 1.0f)) && 0.86f > f2) {
        }
        fArray[0] = f2;
        return n3;
    }

    @Override
    public void clear() {
        this.backingStore.clear();
        this.reap();
    }

    @Override
    public boolean containsKey(Object object) {
        this.reap();
        return this.backingStore.containsKey(new IdentityWeakReference<Object>(object, (ReferenceQueue<Object>)this.queue));
    }

    @Override
    public boolean containsValue(Object object) {
        this.reap();
        return this.backingStore.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.reap();
        HashSet<1> hashSet = new HashSet<1>();
        for (Map.Entry<IdentityWeakReference<K>, V> entry : this.backingStore.entrySet()) {
            final Object t2 = entry.getKey().get();
            if (null == t2) continue;
            final V v2 = entry.getValue();
            Map.Entry entry2 = new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return t2;
                }

                @Override
                public V getValue() {
                    return v2;
                }

                @Override
                public V setValue(V v22) {
                    throw new UnsupportedOperationException();
                }
            };
            hashSet.add(entry2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<K> keySet() {
        this.reap();
        HashSet hashSet = new HashSet();
        for (IdentityWeakReference<K> identityWeakReference : this.backingStore.keySet()) {
            Object t2 = identityWeakReference.get();
            if (null == t2) continue;
            hashSet.add(t2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WeakIdentityHashMap)) {
            return false;
        }
        return this.backingStore.equals(((WeakIdentityHashMap)object).backingStore);
    }

    @Override
    public V get(Object object) {
        this.reap();
        return this.backingStore.get(new IdentityWeakReference<Object>(object, (ReferenceQueue<Object>)this.queue));
    }

    @Override
    public V put(K k2, V v2) {
        this.reap();
        return this.backingStore.put(new IdentityWeakReference<K>(k2, this.queue), v2);
    }

    @Override
    public int hashCode() {
        this.reap();
        return this.backingStore.hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.reap();
        return this.backingStore.isEmpty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n2 = map.size();
        if (0 < n2) {
            float[] fArray = new float[]{0.75f};
            int n3 = WeakIdentityHashMap.capacityForRequiredSize(n2, fArray);
            HashMap<IdentityWeakReference<K>, V> hashMap = new HashMap<IdentityWeakReference<K>, V>(n3, fArray[0]);
            for (Map.Entry<K, V> entry : map.entrySet()) {
                hashMap.put(new IdentityWeakReference<K>(entry.getKey(), this.queue), entry.getValue());
            }
            this.backingStore.putAll(hashMap);
            this.reap();
        }
    }

    @Override
    public V remove(Object object) {
        this.reap();
        return this.backingStore.remove(new IdentityWeakReference<Object>(object, (ReferenceQueue<Object>)this.queue));
    }

    @Override
    public int size() {
        this.reap();
        return this.backingStore.size();
    }

    @Override
    public Collection<V> values() {
        this.reap();
        return this.backingStore.values();
    }

    private synchronized void reap() {
        Reference<K> reference = this.queue.poll();
        while (reference != null) {
            IdentityWeakReference identityWeakReference = (IdentityWeakReference)reference;
            this.backingStore.remove(identityWeakReference);
            reference = this.queue.poll();
        }
    }

    private static class IdentityWeakReference<K>
    extends WeakReference<K> {
        final int hash;

        IdentityWeakReference(K k2, ReferenceQueue<K> referenceQueue) {
            super(k2, referenceQueue);
            this.hash = System.identityHashCode(k2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWeakReference)) {
                return false;
            }
            IdentityWeakReference identityWeakReference = (IdentityWeakReference)object;
            return this.get() == identityWeakReference.get();
        }
    }
}

