/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class UnsafeUtil {
    static final boolean DEBUG = Debug.debug("UnsafeUtil");
    private static final Object theUnsafe;
    private static final Method unsafeCleanBB;
    private static volatile boolean hasUnsafeCleanBBError;
    private static final Method staticFieldOffset;
    private static final Method getObjectVolatile;
    private static final Method putObjectVolatile;
    private static volatile boolean hasGetPutObjectVolatile;
    private static final Class<?> illegalAccessLoggerClass;
    private static final Long illegalAccessLoggerOffset;
    private static final Object illegalAccessLoggerSync;
    private static volatile boolean hasIllegalAccessError;

    protected UnsafeUtil() {
    }

    public static boolean hasInvokeCleaner() {
        return !hasUnsafeCleanBBError;
    }

    public static boolean invokeCleaner(ByteBuffer byteBuffer) {
        if (hasUnsafeCleanBBError || !byteBuffer.isDirect()) {
            return false;
        }
        try {
            unsafeCleanBB.invoke(theUnsafe, byteBuffer);
            return true;
        }
        catch (Throwable throwable) {
            hasUnsafeCleanBBError = true;
            if (DEBUG) {
                ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
            }
            return false;
        }
    }

    public static boolean hasIllegalAccessLoggerAccess() {
        return !hasIllegalAccessError;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doWithoutIllegalAccessLogger(PrivilegedAction<T> privilegedAction) throws RuntimeException {
        if (hasIllegalAccessError) return privilegedAction.run();
        Object object = illegalAccessLoggerSync;
        synchronized (object) {
            T t2;
            Object var2_2 = null;
            Object object2 = null;
            try {
                object2 = getObjectVolatile.invoke(theUnsafe, illegalAccessLoggerClass, illegalAccessLoggerOffset);
                putObjectVolatile.invoke(theUnsafe, illegalAccessLoggerClass, illegalAccessLoggerOffset, var2_2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                hasIllegalAccessError = true;
                if (!DEBUG) return privilegedAction.run();
                ExceptionUtils.dumpThrowable("UnsafeUtil", exception);
                return privilegedAction.run();
            }
            try {
                t2 = privilegedAction.run();
            }
            catch (Throwable throwable) {
                try {
                    if (!DEBUG) throw new RuntimeException(throwable);
                    throwable.printStackTrace();
                    throw new RuntimeException(throwable);
                }
                catch (Throwable throwable2) {
                    try {
                        putObjectVolatile.invoke(theUnsafe, illegalAccessLoggerClass, illegalAccessLoggerOffset, object2);
                        throw throwable2;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        hasIllegalAccessError = true;
                        throw new InternalError(exception);
                    }
                }
            }
            try {
                putObjectVolatile.invoke(theUnsafe, illegalAccessLoggerClass, illegalAccessLoggerOffset, object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                hasIllegalAccessError = true;
                throw new InternalError(exception);
            }
            return t2;
        }
    }

    static {
        illegalAccessLoggerSync = new Object();
        final Object[] objectArray = new Object[]{null};
        final Method[] methodArray = new Method[]{null};
        final Method[] methodArray2 = new Method[]{null};
        final Method[] methodArray3 = new Method[]{null, null};
        final Class[] classArray = new Class[]{null};
        final Long[] longArray = new Long[]{null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block7: {
                    Field field;
                    Class<?> clazz;
                    block6: {
                        clazz = null;
                        try {
                            clazz = Class.forName("sun.misc.Unsafe");
                            field = clazz.getDeclaredField("theUnsafe");
                            field.setAccessible(true);
                            objectArray[0] = field.get(null);
                            methodArray[0] = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                            methodArray[0].setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG) break block6;
                            ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                        }
                    }
                    if (null != objectArray[0] && PlatformPropsImpl.JAVA_9) {
                        try {
                            methodArray2[0] = clazz.getDeclaredMethod("staticFieldOffset", Field.class);
                            methodArray3[0] = clazz.getDeclaredMethod("getObjectVolatile", Object.class, Long.TYPE);
                            methodArray3[1] = clazz.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
                            if (PlatformPropsImpl.JAVA_9) {
                                classArray[0] = Class.forName("jdk.internal.module.IllegalAccessLogger");
                                field = classArray[0].getDeclaredField("logger");
                                longArray[0] = (Long)methodArray2[0].invoke(objectArray[0], field);
                            }
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG) break block7;
                            ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                        }
                    }
                }
                return null;
            }
        });
        theUnsafe = objectArray[0];
        unsafeCleanBB = methodArray[0];
        boolean bl = hasUnsafeCleanBBError = null == theUnsafe || null == unsafeCleanBB;
        if (DEBUG) {
            System.err.println("UnsafeUtil.init: hasTheUnsafe: " + (null != theUnsafe) + ", hasInvokeCleaner: " + !hasUnsafeCleanBBError);
        }
        staticFieldOffset = methodArray2[0];
        getObjectVolatile = methodArray3[0];
        putObjectVolatile = methodArray3[1];
        hasGetPutObjectVolatile = null != staticFieldOffset && null != getObjectVolatile && null != putObjectVolatile;
        illegalAccessLoggerClass = classArray[0];
        illegalAccessLoggerOffset = longArray[0];
        boolean bl2 = hasIllegalAccessError = !hasGetPutObjectVolatile || null == illegalAccessLoggerClass || null == illegalAccessLoggerOffset;
        if (DEBUG) {
            System.err.println("UnsafeUtil.init: hasUnsafeGetPutObjectVolatile: " + hasGetPutObjectVolatile + ", hasUnsafeIllegalAccessLogger: " + !hasIllegalAccessError);
        }
    }
}

