/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import jogamp.common.Debug;

public class SHASum {
    private static final boolean DEBUG = Debug.debug("SHASum");
    final MessageDigest digest;
    final List<String> origins;
    final List<Pattern> excludes;
    final List<Pattern> includes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long updateDigest(MessageDigest messageDigest, List<String> list) throws IOException {
        long l2 = 0L;
        byte[] byArray = new byte[4096];
        block3: for (int i2 = 0; i2 < list.size(); ++i2) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(list.get(i2)));){
                while (true) {
                    int n2;
                    if ((n2 = ((InputStream)bufferedInputStream).read(byArray)) == -1) {
                        continue block3;
                    }
                    messageDigest.update(byArray, 0, n2);
                    l2 += (long)n2;
                }
            }
        }
        return l2;
    }

    public static StringBuilder toHexString(byte[] byArray, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuilder.append(String.format((Locale)null, "%02x", byArray[i2]));
        }
        return stringBuilder;
    }

    public static List<String> sort(ArrayList<String> arrayList) {
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, 0, stringArray.length, null);
        return Arrays.asList(stringArray);
    }

    public SHASum(MessageDigest messageDigest, List<String> list, List<Pattern> list2, List<Pattern> list3) {
        this.digest = messageDigest;
        this.origins = list;
        this.excludes = list2;
        this.includes = list3;
    }

    public final byte[] compute(boolean bl) throws IOException {
        List<String> list = SHASum.sort(IOUtil.filesOf(this.origins, this.excludes, this.includes));
        if (bl) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                System.err.println(list.get(i2));
            }
        }
        long l2 = SHASum.updateDigest(this.digest, list);
        byte[] byArray = this.digest.digest();
        if (bl) {
            System.err.println("Digested " + l2 + " bytes, shasum size " + byArray.length + " bytes");
            System.err.println("Digested result: " + SHASum.toHexString(byArray, null).toString());
        }
        return byArray;
    }

    public final List<String> getOrigins() {
        return this.origins;
    }

    public final List<Pattern> getExcludes() {
        return this.excludes;
    }

    public final List<Pattern> getIncludes() {
        return this.includes;
    }

    public static void main(String[] stringArray) throws IOException {
        MessageDigest messageDigest;
        int n2;
        boolean bl = false;
        int n3 = 256;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Pattern> arrayList2 = new ArrayList<Pattern>();
        ArrayList<Pattern> arrayList3 = new ArrayList<Pattern>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (null == stringArray[n2]) continue;
            if (stringArray[n2].startsWith("--")) {
                if (stringArray[n2].equals("--algorithm")) {
                    n3 = Integer.parseInt(stringArray[++n2]);
                    continue;
                }
                if (stringArray[n2].equals("--exclude")) {
                    arrayList2.add(Pattern.compile(stringArray[++n2]));
                    if (!DEBUG) continue;
                    System.err.println("adding exclude: <" + stringArray[n2] + "> -> <" + arrayList2.get(arrayList2.size() - 1) + ">");
                    continue;
                }
                if (stringArray[n2].equals("--include")) {
                    arrayList3.add(Pattern.compile(stringArray[++n2]));
                    if (!DEBUG) continue;
                    System.err.println("adding include: <" + stringArray[n2] + "> -> <" + arrayList3.get(arrayList3.size() - 1) + ">");
                    continue;
                }
                if (stringArray[n2].equals("--listfilesonly")) {
                    bl = true;
                    continue;
                }
                System.err.println("Abort, unknown argument: " + stringArray[n2]);
                return;
            }
            arrayList.add(stringArray[n2]);
            if (!DEBUG) continue;
            System.err.println("adding path: <" + stringArray[n2] + ">");
        }
        if (bl) {
            List<String> list = SHASum.sort(IOUtil.filesOf(arrayList, arrayList2, arrayList3));
            for (n2 = 0; n2 < list.size(); ++n2) {
                System.out.println(list.get(n2));
            }
            return;
        }
        String string = "SHA-" + n3;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Abort, implementation for " + string + " not available: " + noSuchAlgorithmException.getMessage());
            return;
        }
        SHASum sHASum = new SHASum(messageDigest, arrayList, arrayList2, arrayList3);
        System.out.println(SHASum.toHexString(sHASum.compute(DEBUG), null).toString());
    }

    public static class TempJarSHASum
    extends SHASum {
        public TempJarSHASum(MessageDigest messageDigest, Class<?> clazz, List<Pattern> list, List<Pattern> list2) throws SecurityException, IllegalArgumentException, IOException, URISyntaxException {
            super(messageDigest, Arrays.asList(IOUtil.slashify(TempJarCache.getTempFileCache().getTempDir().getAbsolutePath(), false, false)), list, list2);
            TempJarCache.addAll(clazz, JarUtil.getJarFileUri(clazz.getName(), clazz.getClassLoader()));
        }

        public final String getOrigin() {
            return (String)this.origins.get(0);
        }
    }
}

