/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.SecurityUtil;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class PropertyAccess {
    public static final String jnlp_prefix = "jnlp.";
    public static final String javaws_prefix = "javaws.";
    static final HashSet<String> trustedPrefixes = new HashSet();
    static final HashSet<String> trusted;

    protected static final void addTrustedPrefix(String string) throws AccessControlException {
        SecurityUtil.checkAllPermissions();
        trustedPrefixes.add(string);
    }

    public static final boolean isTrusted(String string) {
        int n2 = string.indexOf(46);
        if (0 <= n2) {
            return trustedPrefixes.contains(string.substring(0, n2 + 1)) || trusted.contains(string);
        }
        return false;
    }

    public static final int getIntProperty(String string, boolean bl, int n2) {
        int n3 = n2;
        try {
            String string2 = PropertyAccess.getProperty(string, bl);
            if (null != string2) {
                n3 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n3;
    }

    public static final long getLongProperty(String string, boolean bl, long l2) {
        long l3 = l2;
        try {
            String string2 = PropertyAccess.getProperty(string, bl);
            if (null != string2) {
                l3 = Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l3;
    }

    public static final boolean getBooleanProperty(String string, boolean bl) {
        return Boolean.valueOf(PropertyAccess.getProperty(string, bl));
    }

    public static final boolean getBooleanProperty(String string, boolean bl, boolean bl2) {
        String string2 = PropertyAccess.getProperty(string, bl);
        if (null != string2) {
            return Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static final boolean isPropertyDefined(String string, boolean bl) {
        return PropertyAccess.getProperty(string, bl) != null;
    }

    public static final String getProperty(String string, boolean bl) throws SecurityException, NullPointerException, IllegalArgumentException {
        if (null == string) {
            throw new NullPointerException("propertyKey is NULL");
        }
        if (0 == string.length()) {
            throw new IllegalArgumentException("propertyKey is empty");
        }
        String string2 = null;
        string2 = PropertyAccess.isTrusted(string) ? PropertyAccess.getTrustedPropKey(string) : System.getProperty(string);
        if (null == string2 && bl && !string.startsWith(jnlp_prefix)) {
            string2 = PropertyAccess.getTrustedPropKey(jnlp_prefix + string);
        }
        return string2;
    }

    public static final String getProperty(String string, boolean bl, String string2) throws SecurityException, NullPointerException, IllegalArgumentException {
        String string3 = PropertyAccess.getProperty(string, bl);
        if (null != string3) {
            return string3;
        }
        return string2;
    }

    private static final String getTrustedPropKey(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Could not access trusted property '" + string + "'", securityException);
                }
            }
        });
    }

    static {
        trustedPrefixes.add(javaws_prefix);
        trustedPrefixes.add(jnlp_prefix);
        trusted = new HashSet();
        trusted.add("sun.java2d.opengl");
        trusted.add("sun.java2d.noddraw");
        trusted.add("sun.java2d.d3d");
        trusted.add("sun.awt.noerasebackground");
    }
}

