/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArrayHashMap<K, V>
implements Cloneable,
Map<K, V> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final HashMap<K, V> map;
    private final ArrayList<V> data;
    private final boolean supportNullValue;

    public ArrayHashMap(boolean bl, int n2, float f2) {
        this.map = new HashMap(n2, f2);
        this.data = new ArrayList(n2);
        this.supportNullValue = bl;
    }

    public ArrayHashMap(ArrayHashMap<K, V> arrayHashMap) {
        this.map = new HashMap<K, V>(arrayHashMap.map);
        this.data = new ArrayList<V>(arrayHashMap.data);
        this.supportNullValue = arrayHashMap.supportNullValue;
    }

    public final boolean supportsNullValue() {
        return this.supportNullValue;
    }

    public final Object clone() {
        return new ArrayHashMap<K, V>(this);
    }

    public final ArrayList<V> getData() {
        return this.data;
    }

    public final ArrayList<V> toArrayList() {
        return new ArrayList<V>(this.data);
    }

    public final HashMap<K, V> getMap() {
        return this.map;
    }

    public final String toString() {
        return this.data.toString();
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public final V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public final V put(K k2, V v2) throws NullPointerException {
        V v3;
        if (this.supportNullValue) {
            boolean bl = this.map.containsKey(k2);
            if (!bl) {
                v3 = this.map.put(k2, v2);
                if (null != v3) {
                    throw new InternalError("Already existing, but checked before: " + k2 + " -> " + v3);
                }
            } else {
                v3 = this.map.put(k2, v2);
                if (!this.data.remove(v3)) {
                    throw new InternalError("Already existing, but not in list: " + v3);
                }
            }
        } else {
            ArrayHashMap.checkNullValue(v2);
            v3 = this.map.put(k2, v2);
            if (null != v3 && !this.data.remove(v3)) {
                throw new InternalError("Already existing, but not in list: " + v3);
            }
        }
        if (!this.data.add(v2)) {
            throw new InternalError("Couldn't add value to list: " + v2);
        }
        return v3;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final V remove(Object object) {
        if (this.supportNullValue) {
            if (this.map.containsKey(object)) {
                V v2 = this.map.remove(object);
                if (!this.data.remove(v2)) {
                    throw new InternalError("Couldn't remove prev mapped pair: " + object + " -> " + v2);
                }
                return v2;
            }
        } else {
            V v3 = this.map.remove(object);
            if (null != v3 && !this.data.remove(v3)) {
                throw new InternalError("Couldn't remove prev mapped pair: " + object + " -> " + v3);
            }
            return v3;
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof ArrayHashMap)) {
            return false;
        }
        return this.map.equals(((ArrayHashMap)object).map);
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    private static final void checkNullValue(Object object) throws NullPointerException {
        if (null == object) {
            throw new NullPointerException("Null value not supported");
        }
    }
}

