/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.MappedByteBufferOutputStream;
import com.jogamp.common.os.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import jogamp.common.Debug;

public class MappedByteBufferInputStream
extends InputStream {
    private static final FileResizeOp NoFileResize = new FileResizeOp(){

        @Override
        public void setLength(long l2) throws IOException {
            throw new IOException("file size change not supported");
        }
    };
    public static final int DEFAULT_SLICE_SHIFT;
    static final boolean DEBUG;
    private final int sliceShift;
    private final FileChannel fc;
    private final FileChannel.MapMode mmode;
    private FileResizeOp fileResizeOp = NoFileResize;
    private int sliceCount;
    private ByteBuffer[] slices;
    private WeakReference<ByteBuffer>[] slices2GC;
    private long totalSize;
    private int slicesEntries;
    private int slices2GCEntries;
    private boolean synchronous;
    private int refCount;
    private CacheMode cmode;
    private int sliceIdx;
    private long mark;

    final void dbgDump(String string, PrintStream printStream) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.sliceCount; ++n2) {
            if (null == this.slices[n2]) continue;
            ++n3;
        }
        n2 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.sliceCount; ++i2) {
            WeakReference<ByteBuffer> weakReference = this.slices2GC[i2];
            if (null == weakReference) continue;
            ++n2;
            if (null == weakReference.get()) continue;
            ++n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (this.fc.isOpen()) {
            try {
                l2 = this.fc.size();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (0 < this.refCount) {
            try {
                l3 = this.position();
                l4 = this.totalSize - l3;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        int n5 = null != this.slices ? this.slices.length : 0;
        printStream.println(string + " refCount " + this.refCount + ", fcSize " + l2 + ", totalSize " + this.totalSize);
        printStream.println(string + " position " + l3 + ", remaining " + l4);
        printStream.println(string + " mmode " + this.mmode + ", cmode " + (Object)((Object)this.cmode) + ", fileResizeOp " + this.fileResizeOp);
        printStream.println(string + " slice " + this.sliceIdx + " / " + this.sliceCount + " (" + n5 + "), synchronous " + this.synchronous);
        printStream.println(string + "   mapped   " + this.slicesEntries + " / " + n3);
        printStream.println(string + "   GC-queue " + this.slices2GCEntries + " / " + n2 + " (alive " + n4 + ")");
        printStream.println(string + " sliceShift " + this.sliceShift + " -> " + (1L << this.sliceShift));
    }

    MappedByteBufferInputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, CacheMode cacheMode, int n2, long l2, int n3) throws IOException {
        this.sliceShift = n2;
        this.fc = fileChannel;
        this.mmode = mapMode;
        if (0L > l2) {
            throw new IllegalArgumentException("Negative size " + l2);
        }
        this.totalSize = -1L;
        this.sliceCount = 0;
        this.notifyLengthChange(l2);
        this.refCount = 1;
        this.cmode = cacheMode;
        this.sliceIdx = n3;
        this.mark = -1L;
        this.currentSlice().position(0);
        if (DEBUG) {
            this.dbgDump("CTOR", System.err);
        }
    }

    public MappedByteBufferInputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, CacheMode cacheMode, int n2) throws IOException {
        this(fileChannel, mapMode, cacheMode, n2, fileChannel.size(), 0);
    }

    public MappedByteBufferInputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, CacheMode cacheMode) throws IOException {
        this(fileChannel, mapMode, cacheMode, DEFAULT_SLICE_SHIFT);
    }

    public MappedByteBufferInputStream(FileChannel fileChannel) throws IOException {
        this(fileChannel, FileChannel.MapMode.READ_ONLY, CacheMode.FLUSH_PRE_HARD, DEFAULT_SLICE_SHIFT);
    }

    public final synchronized void setSynchronous(boolean bl) {
        this.synchronous = bl;
    }

    public final synchronized boolean getSynchronous() {
        return this.synchronous;
    }

    final synchronized void checkOpen() throws IOException {
        if (0 == this.refCount) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public final synchronized void close() throws IOException {
        if (0 < this.refCount) {
            --this.refCount;
            if (0 == this.refCount) {
                try {
                    this.cleanAllSlices(true);
                }
                finally {
                    this.flushImpl(true, false);
                    this.fc.close();
                    this.mark = -1L;
                    this.sliceIdx = -1;
                    super.close();
                }
            }
        }
        if (DEBUG) {
            this.dbgDump("Close", System.err);
        }
    }

    final FileChannel.MapMode getMapMode() {
        return this.mmode;
    }

    public final synchronized void setFileResizeOp(FileResizeOp fileResizeOp) throws IllegalStateException {
        if (NoFileResize != this.fileResizeOp && this.fileResizeOp != fileResizeOp) {
            throw new IllegalStateException("FileResizeOp already set, this value differs");
        }
        this.fileResizeOp = null != fileResizeOp ? fileResizeOp : NoFileResize;
    }

    public final synchronized void setLength(long l2) throws IOException {
        long l3 = 0L != l2 && this.totalSize != l2 ? this.position() : -1L;
        if (this.fc.size() != l2) {
            if (Platform.OSType.WINDOWS == Platform.getOSType()) {
                this.cleanAllSlices(this.synchronous);
            }
            this.fileResizeOp.setLength(l2);
            if (this.synchronous) {
                this.flushImpl(true, false);
            }
        }
        this.notifyLengthChangeImpl(l2, l3);
    }

    public final synchronized void notifyLengthChange(long l2) throws IOException {
        this.notifyLengthChangeImpl(l2, -1L);
    }

    private final synchronized void notifyLengthChangeImpl(long l2, long l3) throws IOException {
        if (this.totalSize == l2) {
            return;
        }
        if (0L == l2) {
            this.cleanAllSlices(this.synchronous);
            WeakReference[] weakReferenceArray = new WeakReference[1];
            this.slices2GC = weakReferenceArray;
            this.slices = new ByteBuffer[1];
            this.slices[0] = ByteBuffer.allocate(0);
            this.sliceCount = 0;
            this.totalSize = 0L;
            this.mark = -1L;
            this.sliceIdx = 0;
        } else {
            long l4 = 0L <= l3 ? l3 : this.position();
            long l5 = 1L << this.sliceShift;
            int n2 = (int)((l2 + (l5 - 1L)) / l5);
            WeakReference[] weakReferenceArray = new WeakReference[n2];
            ByteBuffer[] byteBufferArray = new ByteBuffer[n2];
            int n3 = Math.min(n2, this.sliceCount - 1);
            if (0 <= n3) {
                if (0 < n3) {
                    System.arraycopy(this.slices2GC, 0, weakReferenceArray, 0, n3);
                    System.arraycopy(this.slices, 0, byteBufferArray, 0, n3);
                }
                for (int i2 = n3; i2 < this.sliceCount; ++i2) {
                    this.cleanSlice(i2, this.synchronous);
                }
            }
            this.slices2GC = weakReferenceArray;
            this.slices = byteBufferArray;
            this.sliceCount = n2;
            this.totalSize = l2;
            if (l2 < this.mark) {
                this.mark = -1L;
            }
            this.position2(Math.min(l4, l2));
        }
        if (DEBUG) {
            this.dbgDump("NotifyLengthChange", System.err);
        }
    }

    public final synchronized void flush(boolean bl) throws IOException {
        this.checkOpen();
        this.flushImpl(bl, true);
    }

    private final synchronized void flushImpl(boolean bl, boolean bl2) throws IOException {
        if (FileChannel.MapMode.READ_ONLY != this.mmode) {
            if (bl2 && FileChannel.MapMode.READ_WRITE == this.mmode) {
                int n2;
                for (n2 = 0; n2 < this.sliceCount; ++n2) {
                    this.syncSlice(this.slices[n2], true);
                }
                for (n2 = 0; n2 < this.sliceCount; ++n2) {
                    WeakReference<ByteBuffer> weakReference = this.slices2GC[n2];
                    if (null == weakReference) continue;
                    this.syncSlice((ByteBuffer)weakReference.get(), true);
                }
            }
            this.fc.force(bl);
        }
    }

    public final synchronized MappedByteBufferOutputStream getOutputStream(FileResizeOp fileResizeOp) throws IllegalStateException, IOException {
        this.checkOpen();
        MappedByteBufferOutputStream mappedByteBufferOutputStream = new MappedByteBufferOutputStream(this, fileResizeOp);
        ++this.refCount;
        return mappedByteBufferOutputStream;
    }

    public final synchronized ByteBuffer currentSlice() throws IOException {
        WeakReference<ByteBuffer> weakReference;
        ByteBuffer byteBuffer = this.slices[this.sliceIdx];
        if (null != byteBuffer) {
            return byteBuffer;
        }
        if (CacheMode.FLUSH_PRE_SOFT == this.cmode && null != (weakReference = this.slices2GC[this.sliceIdx])) {
            ByteBuffer byteBuffer2 = (ByteBuffer)weakReference.get();
            this.slices2GC[this.sliceIdx] = null;
            --this.slices2GCEntries;
            if (null != byteBuffer2) {
                this.slices[this.sliceIdx] = byteBuffer2;
                ++this.slicesEntries;
                return byteBuffer2;
            }
        }
        long l2 = (long)this.sliceIdx << this.sliceShift;
        MappedByteBuffer mappedByteBuffer = this.fc.map(this.mmode, l2, Math.min(1L << this.sliceShift, this.totalSize - l2));
        this.slices[this.sliceIdx] = mappedByteBuffer;
        ++this.slicesEntries;
        return mappedByteBuffer;
    }

    public final synchronized ByteBuffer nextSlice() throws IOException {
        if (this.sliceIdx < this.sliceCount - 1) {
            this.flushSlice(this.sliceIdx, this.synchronous);
            ++this.sliceIdx;
            ByteBuffer byteBuffer = this.currentSlice();
            byteBuffer.position(0);
            return byteBuffer;
        }
        return null;
    }

    public final synchronized void flushSlices() throws IOException {
        if (null != this.slices) {
            for (int i2 = 0; i2 < this.sliceCount; ++i2) {
                this.flushSlice(i2, this.synchronous);
            }
        }
        if (DEBUG) {
            this.dbgDump("FlushSlices", System.err);
        }
    }

    synchronized void syncSlice(ByteBuffer byteBuffer) throws IOException {
        this.syncSlice(byteBuffer, this.synchronous);
    }

    synchronized void syncSlice(ByteBuffer byteBuffer, boolean bl) throws IOException {
        block3: {
            if (bl && null != byteBuffer && FileChannel.MapMode.READ_WRITE == this.mmode) {
                try {
                    ((MappedByteBuffer)byteBuffer).force();
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block3;
                    System.err.println("Caught " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
    }

    private synchronized void flushSlice(int n2, boolean bl) throws IOException {
        ByteBuffer byteBuffer = this.slices[n2];
        if (null != byteBuffer) {
            if (CacheMode.FLUSH_NONE != this.cmode) {
                this.slices[n2] = null;
                --this.slicesEntries;
                if (CacheMode.FLUSH_PRE_HARD == this.cmode) {
                    if (!this.cleanBuffer(byteBuffer, bl)) {
                        this.slices2GC[n2] = new WeakReference<ByteBuffer>(byteBuffer);
                        ++this.slices2GCEntries;
                    }
                } else {
                    this.syncSlice(byteBuffer, bl);
                    this.slices2GC[n2] = new WeakReference<ByteBuffer>(byteBuffer);
                    ++this.slices2GCEntries;
                }
            } else {
                this.syncSlice(byteBuffer, bl);
            }
        }
    }

    private synchronized void cleanAllSlices(boolean bl) throws IOException {
        if (null != this.slices) {
            for (int i2 = 0; i2 < this.sliceCount; ++i2) {
                this.cleanSlice(i2, bl);
            }
            if (0 != this.slicesEntries || 0 != this.slices2GCEntries) {
                String string = "mappedSliceCount " + this.slicesEntries + ", slices2GCEntries " + this.slices2GCEntries;
                this.dbgDump(string + ": ", System.err);
                throw new InternalError(string);
            }
        }
    }

    private synchronized void cleanSlice(int n2, boolean bl) throws IOException {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = this.slices[n2];
        WeakReference<ByteBuffer> weakReference = this.slices2GC[n2];
        this.slices2GC[n2] = null;
        if (null != weakReference) {
            --this.slices2GCEntries;
            byteBuffer = (ByteBuffer)weakReference.get();
        } else {
            byteBuffer = null;
        }
        if (null != byteBuffer2) {
            this.slices[n2] = null;
            --this.slicesEntries;
            this.cleanBuffer(byteBuffer2, bl);
            if (null != byteBuffer) {
                throw new InternalError("XXX");
            }
        } else if (null != byteBuffer) {
            this.cleanBuffer(byteBuffer, bl);
        }
    }

    private synchronized boolean cleanBuffer(ByteBuffer byteBuffer, boolean bl) throws IOException {
        this.syncSlice(byteBuffer, bl);
        if (!byteBuffer.isDirect()) {
            return false;
        }
        if (!Buffers.Cleaner.clean(byteBuffer) && CacheMode.FLUSH_PRE_HARD == this.cmode) {
            this.cmode = CacheMode.FLUSH_PRE_SOFT;
            return false;
        }
        return true;
    }

    public final synchronized CacheMode getCacheMode() {
        return this.cmode;
    }

    public final synchronized long length() {
        return this.totalSize;
    }

    public final synchronized long remaining() throws IOException {
        return 0 < this.refCount ? this.totalSize - this.position() : 0L;
    }

    @Override
    public final synchronized int available() throws IOException {
        long l2 = this.remaining();
        return l2 <= Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
    }

    public final synchronized long position() throws IOException {
        if (0 < this.refCount) {
            return ((long)this.sliceIdx << this.sliceShift) + (long)this.currentSlice().position();
        }
        return 0L;
    }

    public final synchronized MappedByteBufferInputStream position(long l2) throws IOException {
        this.checkOpen();
        if (this.totalSize < l2 || 0L > l2) {
            throw new IllegalArgumentException("new position " + l2 + " not within [0.." + this.totalSize + "]");
        }
        int n2 = this.sliceIdx;
        if (this.totalSize == l2) {
            this.sliceIdx = Math.max(0, this.sliceCount - 1);
            if (n2 != this.sliceIdx) {
                this.flushSlice(n2, this.synchronous);
            }
            ByteBuffer byteBuffer = this.currentSlice();
            byteBuffer.position(byteBuffer.capacity());
        } else {
            this.sliceIdx = (int)(l2 >>> this.sliceShift);
            if (n2 != this.sliceIdx) {
                this.flushSlice(n2, this.synchronous);
            }
            this.currentSlice().position((int)(l2 - ((long)this.sliceIdx << this.sliceShift)));
        }
        return this;
    }

    private final synchronized void position2(long l2) throws IOException {
        if (this.totalSize == l2) {
            this.sliceIdx = Math.max(0, this.sliceCount - 1);
            ByteBuffer byteBuffer = this.currentSlice();
            byteBuffer.position(byteBuffer.capacity());
        } else {
            this.sliceIdx = (int)(l2 >>> this.sliceShift);
            this.currentSlice().position((int)(l2 - ((long)this.sliceIdx << this.sliceShift)));
        }
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized void mark(int n2) {
        if (0 < this.refCount) {
            try {
                this.mark = this.position();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.checkOpen();
        if (this.mark == -1L) {
            throw new IOException("mark not set");
        }
        this.position(this.mark);
    }

    @Override
    public final synchronized long skip(long l2) throws IOException {
        this.checkOpen();
        if (0L > l2) {
            return 0L;
        }
        long l3 = this.position();
        long l4 = this.totalSize - l3;
        long l5 = Math.min(l4, l2);
        this.position(l3 + l5);
        return l5;
    }

    @Override
    public final synchronized int read() throws IOException {
        this.checkOpen();
        ByteBuffer byteBuffer = this.currentSlice();
        if (!byteBuffer.hasRemaining() && null == (byteBuffer = this.nextSlice())) {
            return -1;
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public final synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.checkOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("offset " + n2 + ", length " + n3 + ", b.length " + byArray.length);
        }
        if (0 == n3) {
            return 0;
        }
        long l2 = this.remaining();
        if (0L == l2) {
            return -1;
        }
        int n5 = (int)Math.min(l2, (long)n3);
        for (int i2 = 0; i2 < n5; i2 += n4) {
            ByteBuffer byteBuffer = this.currentSlice();
            int n6 = byteBuffer.remaining();
            if (0 == n6) {
                byteBuffer = this.nextSlice();
                if (null == byteBuffer) {
                    throw new InternalError("Unexpected EOT");
                }
                n6 = byteBuffer.remaining();
            }
            n4 = Math.min(n5 - i2, n6);
            byteBuffer.get(byArray, n2 + i2, n4);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int read(ByteBuffer byteBuffer, int n2) throws IOException {
        int n3;
        this.checkOpen();
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException("length " + n2 + ", b " + byteBuffer);
        }
        if (0 == n2) {
            return 0;
        }
        long l2 = this.remaining();
        if (0L == l2) {
            return -1;
        }
        int n4 = (int)Math.min(l2, (long)n2);
        for (int i2 = 0; i2 < n4; i2 += n3) {
            ByteBuffer byteBuffer2 = this.currentSlice();
            int n5 = byteBuffer2.remaining();
            if (0 == n5) {
                byteBuffer2 = this.nextSlice();
                if (null == byteBuffer2) {
                    throw new InternalError("Unexpected EOT");
                }
                n5 = byteBuffer2.remaining();
            }
            n3 = Math.min(n4 - i2, n5);
            if (byteBuffer2.hasArray() && byteBuffer.hasArray()) {
                System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n3);
                byteBuffer2.position(byteBuffer2.position() + n3);
                byteBuffer.position(byteBuffer.position() + n3);
                continue;
            }
            if (n3 == n5) {
                byteBuffer.put(byteBuffer2);
                continue;
            }
            int n6 = byteBuffer2.limit();
            byteBuffer2.limit(n3);
            try {
                byteBuffer.put(byteBuffer2);
                continue;
            }
            finally {
                byteBuffer2.limit(n6);
            }
        }
        return n4;
    }

    static {
        Platform.initSingleton();
        DEFAULT_SLICE_SHIFT = Platform.is32Bit() ? 29 : 30;
        DEBUG = Debug.debug("ByteBufferInputStream");
    }

    public static interface FileResizeOp {
        public void setLength(long var1) throws IOException;
    }

    public static enum CacheMode {
        FLUSH_NONE,
        FLUSH_PRE_SOFT,
        FLUSH_PRE_HARD;

    }
}

