/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.net;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.PropertyAccess;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jogamp.common.Debug;

public class Uri {
    private static final boolean DEBUG;
    private static final boolean DEBUG_SHOWFIX;
    private static final int PARSE_HINT_FIX_PATH = 1;
    private static final String DIGITS = "0123456789ABCDEF";
    private static final String ENCODING = "UTF8";
    private static final String MSG_ENCODING_NA = "Charset UTF8 not available";
    private static final Pattern patternSingleFS;
    public static final String UNRESERVED = "_-.~";
    private static final String punct = ",;:$&+=";
    public static final String RESERVED = ",;:$&+=!*'()@/?#[]";
    public static final String RESERVED_2 = ",;:$&+=!*'()@/?[]";
    public static final String USERINFO_LEGAL = "_-.~,;:$&+=";
    public static final String AUTHORITY_LEGAL = "@[]_-.~,;:$&+=";
    public static final String PATH_LEGAL = "/!_-.~";
    public static final String QUERY_LEGAL = "_-.~,;:$&+=!*'()@/?[]\\\"";
    public static final String SSP_LEGAL = "_-.~,;:$&+=!*'()@/?[]\\\"";
    public static final String FRAG_LEGAL = "_-.~,;:$&+=!*'()@/?#[]";
    public static final char SCHEME_SEPARATOR = ':';
    public static final char QUERY_SEPARATOR = '?';
    public static final char FRAGMENT_SEPARATOR = '#';
    public static final String FILE_SCHEME = "file";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String JAR_SCHEME = "jar";
    public static final char JAR_SCHEME_SEPARATOR = '!';
    public final Encoded input;
    private final Object lazyLock = new Object();
    private ASCIIEncoded inputASCII;
    private int hash;
    public final Encoded scheme;
    public final Encoded schemeSpecificPart;
    public final Encoded path;
    public final boolean hasAuthority;
    public final Encoded authority;
    public final Encoded userInfo;
    public final Encoded host;
    public final int port;
    public final Encoded query;
    public final Encoded fragment;
    public final boolean absolute;
    public final boolean opaque;

    private static void encodeChar2UTF8(StringBuilder stringBuilder, char c2) {
        byte[] byArray;
        try {
            byArray = new String(new char[]{c2}).getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(MSG_ENCODING_NA, unsupportedEncodingException);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            stringBuilder.append('%');
            stringBuilder.append(DIGITS.charAt((by & 0xF0) >> 4));
            stringBuilder.append(DIGITS.charAt(by & 0xF));
        }
    }

    public static String encode(String string, String string2) {
        if (null == string) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || string2.indexOf(c2) > -1 || c2 > '\u007f' && !Character.isSpaceChar(c2) && !Character.isISOControl(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            Uri.encodeChar2UTF8(stringBuilder, c2);
        }
        return stringBuilder.toString();
    }

    public static String encodeToASCIIString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u007f') {
                stringBuilder.append(c2);
                continue;
            }
            Uri.encodeChar2UTF8(stringBuilder, c2);
        }
        return stringBuilder.toString();
    }

    public static String decode(Encoded encoded) {
        return null != encoded ? encoded.decode() : null;
    }

    public static String decode(String string) {
        if (null == string) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[32];
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (c2 == '%') {
                n2 = 0;
                do {
                    if (n3 + 2 >= string.length()) {
                        throw new IllegalArgumentException("missing '%' hex-digits at index " + n3);
                    }
                    int n4 = Character.digit(string.charAt(n3 + 1), 16);
                    int n5 = Character.digit(string.charAt(n3 + 2), 16);
                    if (n4 == -1 || n5 == -1) {
                        throw new IllegalArgumentException("invalid hex-digits at index " + n3 + ": " + string.substring(n3, n3 + 3));
                    }
                    byArray[n2++] = (byte)((n4 << 4) + n5);
                    if (32 != n2) continue;
                    Uri.appendUTF8(stringBuilder, byArray, n2);
                    n2 = 0;
                } while ((n3 += 3) < string.length() && string.charAt(n3) == '%');
                if (0 >= n2) continue;
                Uri.appendUTF8(stringBuilder, byArray, n2);
                continue;
            }
            stringBuilder.append(c2);
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static void appendUTF8(StringBuilder stringBuilder, byte[] byArray, int n2) {
        try {
            stringBuilder.append(new String(byArray, 0, n2, ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(MSG_ENCODING_NA, unsupportedEncodingException);
        }
    }

    public static Uri create(String string, String string2, String string3) throws URISyntaxException {
        if (Uri.emptyString(string) && Uri.emptyString(string2) && Uri.emptyString(string3)) {
            throw new URISyntaxException("", "all empty parts");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.emptyString(string)) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        if (!Uri.emptyString(string2)) {
            stringBuilder.append(Uri.encode(string2, "_-.~,;:$&+=!*'()@/?[]\\\""));
        }
        if (!Uri.emptyString(string3)) {
            stringBuilder.append('#');
            stringBuilder.append(Uri.encode(string3, FRAG_LEGAL));
        }
        return new Uri(new Encoded(stringBuilder.toString()), false, 0);
    }

    public static Uri create(Encoded encoded, Encoded encoded2, Encoded encoded3) throws URISyntaxException {
        if (Uri.emptyString(encoded) && Uri.emptyString(encoded2) && Uri.emptyString(encoded3)) {
            throw new URISyntaxException("", "all empty parts");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.emptyString(encoded)) {
            stringBuilder.append(encoded);
            stringBuilder.append(':');
        }
        if (!Uri.emptyString(encoded2)) {
            stringBuilder.append(encoded2.get());
        }
        if (!Uri.emptyString(encoded3)) {
            stringBuilder.append('#');
            stringBuilder.append(encoded3.get());
        }
        return new Uri(new Encoded(stringBuilder.toString()), false, 0);
    }

    public static Uri create(String string, String string2, String string3, int n2, String string4, String string5, String string6) throws URISyntaxException {
        if (Uri.emptyString(string) && Uri.emptyString(string2) && Uri.emptyString(string3) && Uri.emptyString(string4) && Uri.emptyString(string5) && Uri.emptyString(string6)) {
            throw new URISyntaxException("", "all empty parts");
        }
        if (!Uri.emptyString(string) && !Uri.emptyString(string4) && string4.length() > 0 && string4.charAt(0) != '/') {
            throw new URISyntaxException(string4, "path doesn't start with '/'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.emptyString(string)) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        if (!Uri.emptyString(string2) || !Uri.emptyString(string3) || n2 != -1) {
            stringBuilder.append("//");
        }
        if (!Uri.emptyString(string2)) {
            stringBuilder.append(Uri.encode(string2, USERINFO_LEGAL));
            stringBuilder.append('@');
        }
        if (!Uri.emptyString(string3)) {
            if (string3.indexOf(58) != -1 && string3.indexOf(93) == -1 && string3.indexOf(91) == -1) {
                string3 = "[" + string3 + "]";
            }
            stringBuilder.append(string3);
        }
        if (n2 != -1) {
            stringBuilder.append(':');
            stringBuilder.append(n2);
        }
        if (!Uri.emptyString(string4)) {
            stringBuilder.append(Uri.encode(string4, PATH_LEGAL));
        }
        if (!Uri.emptyString(string5)) {
            stringBuilder.append('?');
            stringBuilder.append(Uri.encode(string5, "_-.~,;:$&+=!*'()@/?[]\\\""));
        }
        if (!Uri.emptyString(string6)) {
            stringBuilder.append('#');
            stringBuilder.append(Uri.encode(string6, FRAG_LEGAL));
        }
        return new Uri(new Encoded(stringBuilder.toString()), true, 0);
    }

    public static Uri create(Encoded encoded, Encoded encoded2, Encoded encoded3, int n2, Encoded encoded4, Encoded encoded5, Encoded encoded6) throws URISyntaxException {
        if (Uri.emptyString(encoded) && Uri.emptyString(encoded2) && Uri.emptyString(encoded3) && Uri.emptyString(encoded4) && Uri.emptyString(encoded5) && Uri.emptyString(encoded6)) {
            throw new URISyntaxException("", "all empty parts");
        }
        if (!Uri.emptyString(encoded) && !Uri.emptyString(encoded4) && encoded4.length() > 0 && encoded4.charAt(0) != '/') {
            throw new URISyntaxException(encoded4.get(), "path doesn't start with '/'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.emptyString(encoded)) {
            stringBuilder.append(encoded);
            stringBuilder.append(':');
        }
        if (!Uri.emptyString(encoded2) || !Uri.emptyString(encoded3) || n2 != -1) {
            stringBuilder.append("//");
        }
        if (!Uri.emptyString(encoded2)) {
            stringBuilder.append(encoded2.get());
            stringBuilder.append('@');
        }
        if (!Uri.emptyString(encoded3)) {
            stringBuilder.append(encoded3.get());
        }
        if (n2 != -1) {
            stringBuilder.append(':');
            stringBuilder.append(n2);
        }
        if (!Uri.emptyString(encoded4)) {
            stringBuilder.append(encoded4.get());
        }
        if (!Uri.emptyString(encoded5)) {
            stringBuilder.append('?');
            stringBuilder.append(encoded5.get());
        }
        if (!Uri.emptyString(encoded6)) {
            stringBuilder.append('#');
            stringBuilder.append(encoded6.get());
        }
        return new Uri(new Encoded(stringBuilder.toString()), true, 0);
    }

    public static Uri create(String string, String string2, String string3, String string4) throws URISyntaxException {
        return Uri.create(string, null, string2, -1, string3, null, string4);
    }

    public static Uri create(Encoded encoded, Encoded encoded2, Encoded encoded3, Encoded encoded4) throws URISyntaxException {
        return Uri.create(encoded, null, encoded2, -1, encoded3, null, encoded4);
    }

    public static Uri create(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        if (Uri.emptyString(string) && Uri.emptyString(string2) && Uri.emptyString(string3) && Uri.emptyString(string4) && Uri.emptyString(string5)) {
            throw new URISyntaxException("", "all empty parts");
        }
        if (!Uri.emptyString(string) && !Uri.emptyString(string3) && string3.length() > 0 && string3.charAt(0) != '/') {
            throw new URISyntaxException(string3, "path doesn't start with '/'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.emptyString(string)) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        if (!Uri.emptyString(string2)) {
            stringBuilder.append("//");
            stringBuilder.append(Uri.encode(string2, AUTHORITY_LEGAL));
        }
        if (!Uri.emptyString(string3)) {
            stringBuilder.append(Uri.encode(string3, PATH_LEGAL));
        }
        if (!Uri.emptyString(string4)) {
            stringBuilder.append('?');
            stringBuilder.append(Uri.encode(string4, "_-.~,;:$&+=!*'()@/?[]\\\""));
        }
        if (!Uri.emptyString(string5)) {
            stringBuilder.append('#');
            stringBuilder.append(Uri.encode(string5, FRAG_LEGAL));
        }
        return new Uri(new Encoded(stringBuilder.toString()), false, 0);
    }

    public static Uri create(Encoded encoded, Encoded encoded2, Encoded encoded3, Encoded encoded4, Encoded encoded5) throws URISyntaxException {
        if (Uri.emptyString(encoded) && Uri.emptyString(encoded2) && Uri.emptyString(encoded3) && Uri.emptyString(encoded4) && Uri.emptyString(encoded5)) {
            throw new URISyntaxException("", "all empty parts");
        }
        if (!Uri.emptyString(encoded) && !Uri.emptyString(encoded3) && encoded3.length() > 0 && encoded3.charAt(0) != '/') {
            throw new URISyntaxException(encoded3.get(), "path doesn't start with '/'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!Uri.emptyString(encoded)) {
            stringBuilder.append(encoded);
            stringBuilder.append(':');
        }
        if (!Uri.emptyString(encoded2)) {
            stringBuilder.append("//");
            stringBuilder.append(encoded2.get());
        }
        if (!Uri.emptyString(encoded3)) {
            stringBuilder.append(encoded3.get());
        }
        if (!Uri.emptyString(encoded4)) {
            stringBuilder.append('?');
            stringBuilder.append(encoded4.get());
        }
        if (!Uri.emptyString(encoded5)) {
            stringBuilder.append('#');
            stringBuilder.append(encoded5.get());
        }
        return new Uri(new Encoded(stringBuilder.toString()), false, 0);
    }

    public static Uri cast(String string) throws URISyntaxException {
        return new Uri(Encoded.cast(string));
    }

    public static Uri valueOfFilepath(String string) throws URISyntaxException {
        if (Uri.emptyString(string)) {
            throw new URISyntaxException("", "empty path");
        }
        if (string.charAt(0) != '/') {
            throw new URISyntaxException(string, "path doesn't start with '/'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FILE_SCHEME);
        stringBuilder.append(':');
        stringBuilder.append(Uri.encode(string, PATH_LEGAL));
        return new Uri(new Encoded(stringBuilder.toString()), false, 0);
    }

    public static Uri valueOf(File file) throws URISyntaxException {
        return Uri.valueOfFilepath(IOUtil.slashify(file.getAbsolutePath(), true, file.isDirectory()));
    }

    public static Uri valueOf(URI uRI) throws URISyntaxException {
        if (uRI.isOpaque()) {
            return new Uri(new Encoded(uRI.toString()), false, 0);
        }
        return Uri.create(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
    }

    public static Uri valueOf(URL uRL) throws URISyntaxException {
        return Uri.valueOf(uRL.toURI());
    }

    public Uri(Encoded encoded) throws URISyntaxException {
        this(encoded, false, 0);
    }

    public final boolean isFileScheme() {
        return null != this.scheme && FILE_SCHEME.equals(this.scheme.get());
    }

    public final boolean isJarScheme() {
        return null != this.scheme && JAR_SCHEME.equals(this.scheme.get());
    }

    public final Encoded getEncoded() {
        return this.input;
    }

    public final String toString() {
        return this.input.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASCIIEncoded toASCIIString() {
        Object object = this.lazyLock;
        synchronized (object) {
            if (null == this.inputASCII) {
                this.inputASCII = new ASCIIEncoded(this.input.get());
            }
            return this.inputASCII;
        }
    }

    public final URI toURI() {
        try {
            return new URI(this.input.get());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    public final URI toURIReencoded() throws URISyntaxException {
        URI uRI = this.opaque ? new URI(Uri.decode(this.scheme), Uri.decode(this.schemeSpecificPart), Uri.decode(this.fragment)) : (null != this.host ? new URI(Uri.decode(this.scheme), Uri.decode(this.userInfo), Uri.decode(this.host), this.port, Uri.decode(this.path), Uri.decode(this.query), Uri.decode(this.fragment)) : new URI(Uri.decode(this.scheme), Uri.decode(this.authority), Uri.decode(this.path), Uri.decode(this.query), Uri.decode(this.fragment)));
        return uRI;
    }

    public final URL toURL() throws MalformedURLException {
        if (!this.absolute) {
            throw new IllegalArgumentException("Cannot convert relative Uri: " + this.input);
        }
        return new URL(this.input.get());
    }

    public final File toFile() {
        if (this.isFileScheme() && !Uri.emptyString(this.path)) {
            String string = null == this.authority ? "" : "//" + this.authority.decode();
            String string2 = string + this.path.decode();
            if (File.separator.equals("\\")) {
                String string3 = patternSingleFS.matcher(string2).replaceAll("\\\\");
                if (string3.startsWith("\\") && !string3.startsWith("\\\\")) {
                    return new File(string3.substring(1));
                }
                return new File(string3);
            }
            return new File(string2);
        }
        return null;
    }

    public final Uri getContainedUri() throws URISyntaxException {
        block8: {
            if (!Uri.emptyString(this.schemeSpecificPart)) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                if (this.isJarScheme()) {
                    n2 = this.schemeSpecificPart.lastIndexOf(33);
                    if (0 > n2) {
                        throw new URISyntaxException(this.input.get(), "missing jar separator");
                    }
                    stringBuilder.append(this.schemeSpecificPart.get().substring(0, n2));
                } else {
                    stringBuilder.append(this.schemeSpecificPart.get());
                }
                if (!Uri.emptyString(this.fragment)) {
                    stringBuilder.append('#');
                    stringBuilder.append(this.fragment);
                }
                try {
                    n2 = this.opaque ? 1 : 0;
                    Uri uri = new Uri(new Encoded(stringBuilder.toString()), false, n2);
                    if (null != uri.scheme) {
                        return uri;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!DEBUG) break block8;
                    System.err.println("Caught " + uRISyntaxException.getClass().getSimpleName() + ": " + uRISyntaxException.getMessage());
                    uRISyntaxException.printStackTrace();
                }
            }
        }
        return null;
    }

    private static final boolean cutoffLastPathSegementImpl(StringBuilder stringBuilder, boolean bl, boolean bl2, Encoded encoded) throws URISyntaxException {
        int n2;
        String string = stringBuilder.toString();
        if (0 > string.indexOf("/") && Uri.emptyString(encoded)) {
            return false;
        }
        stringBuilder.setLength(0);
        stringBuilder.append(IOUtil.cleanPathString(string));
        boolean bl3 = stringBuilder.length() != string.length();
        string = stringBuilder.toString();
        int n3 = string.lastIndexOf(33);
        int n4 = string.lastIndexOf("/");
        if (0 > n3 || n4 - 1 > n3) {
            if (bl && n4 < string.length() - 1) {
                stringBuilder.setLength(0);
                stringBuilder.append(string.substring(0, n4 + 1));
            } else if (bl2 && (n2 = string.lastIndexOf("/", n4 - 1)) >= 0) {
                stringBuilder.setLength(0);
                stringBuilder.append(string.substring(0, n2 + 1));
            }
        }
        int n5 = n2 = stringBuilder.length() != string.length() ? 1 : 0;
        if (n2 == 0 && (bl2 || !bl3) && Uri.emptyString(encoded)) {
            return false;
        }
        if (!Uri.emptyString(encoded)) {
            stringBuilder.append(encoded.get());
            string = stringBuilder.toString();
            stringBuilder.setLength(0);
            stringBuilder.append(IOUtil.cleanPathString(string));
        }
        return true;
    }

    private final Uri cutoffLastPathSegementImpl(boolean bl, boolean bl2, Encoded encoded) throws URISyntaxException {
        if (this.opaque) {
            Encoded encoded2;
            if (Uri.emptyString(this.schemeSpecificPart)) {
                if (!Uri.emptyString(encoded)) {
                    return Uri.create(this.scheme, encoded, this.fragment);
                }
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.schemeSpecificPart.lastIndexOf(63);
            if (n2 >= 0) {
                encoded2 = this.schemeSpecificPart.substring(n2 + 1);
                stringBuilder.append(this.schemeSpecificPart.substring(0, n2).get());
            } else {
                encoded2 = null;
                stringBuilder.append(this.schemeSpecificPart.get());
            }
            if (!Uri.cutoffLastPathSegementImpl(stringBuilder, bl, bl2, encoded)) {
                return null;
            }
            if (!Uri.emptyString(encoded2)) {
                stringBuilder.append('?');
                stringBuilder.append(encoded2.get());
            }
            return Uri.create(this.scheme, new Encoded(stringBuilder.toString()), this.fragment);
        }
        if (Uri.emptyString(this.path)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.path.get());
        if (!Uri.cutoffLastPathSegementImpl(stringBuilder, bl, bl2, encoded)) {
            return null;
        }
        return Uri.create(this.scheme, this.userInfo, this.host, this.port, new Encoded(stringBuilder.toString()), this.query, this.fragment);
    }

    public final Uri getNormalized() {
        try {
            Uri uri = this.cutoffLastPathSegementImpl(false, false, null);
            return null != uri ? uri : this;
        }
        catch (URISyntaxException uRISyntaxException) {
            if (DEBUG) {
                System.err.println("Caught " + uRISyntaxException.getClass().getSimpleName() + ": " + uRISyntaxException.getMessage());
                uRISyntaxException.printStackTrace();
            }
            return this;
        }
    }

    public Uri getDirectory() {
        try {
            Uri uri = this.cutoffLastPathSegementImpl(true, false, null);
            return null != uri ? uri : this;
        }
        catch (URISyntaxException uRISyntaxException) {
            if (DEBUG) {
                System.err.println("Caught " + uRISyntaxException.getClass().getSimpleName() + ": " + uRISyntaxException.getMessage());
                uRISyntaxException.printStackTrace();
            }
            return this;
        }
    }

    public final Uri getParent() {
        try {
            return this.cutoffLastPathSegementImpl(true, true, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (DEBUG) {
                System.err.println("Caught " + uRISyntaxException.getClass().getSimpleName() + ": " + uRISyntaxException.getMessage());
                uRISyntaxException.printStackTrace();
            }
            return null;
        }
    }

    public Uri getRelativeOf(Encoded encoded) throws URISyntaxException {
        if (Uri.emptyString(encoded)) {
            return this.getNormalized();
        }
        return this.cutoffLastPathSegementImpl(true, false, encoded);
    }

    public final Uri concat(Encoded encoded) throws URISyntaxException {
        if (null == encoded) {
            return this;
        }
        return new Uri(this.input.concat(encoded));
    }

    public final Uri getNewQuery(Encoded encoded) throws URISyntaxException {
        if (this.opaque) {
            throw new URISyntaxException(this.input.decode(), "Opaque Uri cannot permute by query");
        }
        return Uri.create(this.scheme, this.userInfo, this.host, this.port, this.path, encoded, this.fragment);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Uri)) {
            return false;
        }
        Uri uri = (Uri)object;
        if (uri.fragment == null && this.fragment != null || uri.fragment != null && this.fragment == null) {
            return false;
        }
        if (uri.fragment != null && this.fragment != null && !this.equalsHexCaseInsensitive(uri.fragment, this.fragment)) {
            return false;
        }
        if (uri.scheme == null && this.scheme != null || uri.scheme != null && this.scheme == null) {
            return false;
        }
        if (uri.scheme != null && this.scheme != null && !uri.scheme.equalsIgnoreCase(this.scheme)) {
            return false;
        }
        if (uri.opaque && this.opaque) {
            return this.equalsHexCaseInsensitive(uri.schemeSpecificPart, this.schemeSpecificPart);
        }
        if (!uri.opaque && !this.opaque) {
            if (!this.equalsHexCaseInsensitive(this.path, uri.path)) {
                return false;
            }
            if (uri.query != null && this.query == null || uri.query == null && this.query != null) {
                return false;
            }
            if (uri.query != null && this.query != null && !this.equalsHexCaseInsensitive(uri.query, this.query)) {
                return false;
            }
            if (uri.authority != null && this.authority == null || uri.authority == null && this.authority != null) {
                return false;
            }
            if (uri.authority != null && this.authority != null) {
                if (uri.host != null && this.host == null || uri.host == null && this.host != null) {
                    return false;
                }
                if (uri.host == null && this.host == null) {
                    return this.equalsHexCaseInsensitive(uri.authority, this.authority);
                }
                if (!this.host.equalsIgnoreCase(uri.host)) {
                    return false;
                }
                if (this.port != uri.port) {
                    return false;
                }
                if (uri.userInfo != null && this.userInfo == null || uri.userInfo == null && this.userInfo != null) {
                    return false;
                }
                if (uri.userInfo != null && this.userInfo != null) {
                    return this.equalsHexCaseInsensitive(this.userInfo, uri.userInfo);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        Object object = this.lazyLock;
        synchronized (object) {
            if (this.hash == -1) {
                this.hash = this.getHashString().hashCode();
            }
            return this.hash;
        }
    }

    private String convertHexToLowerCase(String string) {
        if (string.indexOf(37) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf(37, n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2 + 1));
            stringBuilder.append(string.substring(n2 + 1, n2 + 3).toLowerCase());
            n3 = n2 += 3;
        }
        return stringBuilder.toString();
    }

    private boolean equalsHexCaseInsensitive(Encoded encoded, Encoded encoded2) {
        if (encoded.indexOf(37) != encoded2.indexOf(37)) {
            return encoded.equals(encoded2);
        }
        int n2 = 0;
        int n3 = 0;
        while ((n2 = encoded.indexOf(37, n3)) != -1 && encoded2.indexOf(37, n3) == n2) {
            if (!encoded.get().substring(n3, n2).equals(encoded2.get().substring(n3, n2))) {
                return false;
            }
            if (!encoded.get().substring(n2 + 1, n2 + 3).equalsIgnoreCase(encoded2.get().substring(n2 + 1, n2 + 3))) {
                return false;
            }
            n3 = n2 += 3;
        }
        return encoded.get().substring(n3).equals(encoded2.get().substring(n3));
    }

    private String getHashString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheme != null) {
            stringBuilder.append(this.scheme.get().toLowerCase());
            stringBuilder.append(':');
        }
        if (this.opaque) {
            stringBuilder.append(this.schemeSpecificPart.get());
        } else {
            if (this.authority != null) {
                stringBuilder.append("//");
                if (this.host == null) {
                    stringBuilder.append(this.authority.get());
                } else {
                    if (this.userInfo != null) {
                        stringBuilder.append(this.userInfo.get() + "@");
                    }
                    stringBuilder.append(this.host.get().toLowerCase());
                    if (this.port != -1) {
                        stringBuilder.append(58 + this.port);
                    }
                }
            }
            if (this.path != null) {
                stringBuilder.append(this.path.get());
            }
            if (this.query != null) {
                stringBuilder.append('?');
                stringBuilder.append(this.query.get());
            }
        }
        if (this.fragment != null) {
            stringBuilder.append('#');
            stringBuilder.append(this.fragment.get());
        }
        return this.convertHexToLowerCase(stringBuilder.toString());
    }

    private Uri(Encoded encoded, boolean bl, int n2) throws URISyntaxException {
        int n3;
        int n4;
        int n5;
        CharSequence charSequence;
        String string;
        int n6;
        if (Uri.emptyString(encoded)) {
            throw new URISyntaxException(encoded.get(), "empty input");
        }
        String string2 = encoded.get();
        int n7 = string2.indexOf(35);
        if (n7 != -1) {
            this.fragment = new Encoded(string2.substring(n7 + 1));
            Uri.validateFragment(encoded, this.fragment, n7 + 1);
            string2 = string2.substring(0, n7);
        } else {
            this.fragment = null;
        }
        String string3 = encoded.get();
        n7 = n6 = string2.indexOf(58);
        int n8 = string2.indexOf(47);
        int n9 = string2.indexOf(63);
        if (!(n6 == -1 || n8 < n6 && n8 != -1 || n9 < n6 && n9 != -1)) {
            this.absolute = true;
            this.scheme = new Encoded(string2.substring(0, n6));
            if (this.scheme.length() == 0) {
                Uri.failExpecting(encoded, "scheme", n6);
            }
            Uri.validateScheme(encoded, this.scheme, 0);
            string = string2.substring(n6 + 1);
            if (string.length() == 0) {
                Uri.failExpecting(encoded, "scheme-specific-part", n6);
            }
        } else {
            this.absolute = false;
            this.scheme = null;
            string = string2;
        }
        if (this.scheme == null || string.length() > 0 && string.charAt(0) == '/') {
            int n10;
            this.opaque = false;
            string2 = string;
            n7 = string2.indexOf(63);
            if (n7 != -1) {
                this.query = new Encoded(string2.substring(n7 + 1));
                string2 = string2.substring(0, n7);
                Uri.validateQuery(encoded, this.query, n8 + 1 + n7);
            } else {
                this.query = null;
            }
            if (string2.startsWith("//")) {
                String string4;
                n7 = string2.indexOf(47, 2);
                if (n7 != -1) {
                    string4 = string2.substring(2, n7);
                    charSequence = string2.substring(n7);
                    n10 = n7;
                } else {
                    string4 = string2.substring(2);
                    if (string4.length() == 0 && this.query == null && this.fragment == null) {
                        Uri.failExpecting(encoded, "authority, path [, query, fragment]", n7);
                    }
                    charSequence = "";
                    n10 = -1;
                }
                if (Uri.emptyString(string4)) {
                    this.authority = null;
                } else {
                    this.authority = new Encoded(string4);
                    Uri.validateAuthority(encoded, this.authority, n6 + 3);
                }
            } else {
                charSequence = string2;
                n10 = 0;
                this.authority = null;
            }
            n5 = 0;
            if (n8 > -1) {
                n5 += n8;
            }
            if (n10 > -1) {
                n5 += n10;
            }
            if (0 <= (n4 = Uri.validateEncoded(charSequence, PATH_LEGAL))) {
                if (0 != (n2 & 1)) {
                    if (DEBUG_SHOWFIX) {
                        System.err.println("Uri FIX_FILEPATH: input at index " + (n5 + n4) + ": " + string3);
                        System.err.println("Uri FIX_FILEPATH: ssp at index   " + (n10 + n4) + ": " + string);
                        System.err.println("Uri FIX_FILEPATH: path  at index " + n4 + ": " + charSequence);
                    }
                    n3 = charSequence.length();
                    charSequence = Uri.encode(Uri.decode(charSequence), PATH_LEGAL);
                    Uri.validatePath(encoded, charSequence, n5);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (n10 > 0) {
                        stringBuilder.append(string.substring(0, n10));
                    }
                    stringBuilder.append((String)charSequence).append(string.substring(n10 + n3));
                    string = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    if (n5 > 0) {
                        stringBuilder.append(string3.substring(0, n5));
                    }
                    stringBuilder.append((String)charSequence).append(string3.substring(n5 + n3));
                    string3 = stringBuilder.toString();
                    if (DEBUG_SHOWFIX) {
                        System.err.println("Uri FIX_FILEPATH: result          : " + charSequence);
                        System.err.println("Uri FIX_FILEPATH: ssp after       : " + string);
                        System.err.println("Uri FIX_FILEPATH: input after     : " + string3);
                    }
                } else {
                    Uri.fail(encoded, "invalid path", n5 + n4);
                }
            }
            this.path = new Encoded((String)charSequence);
        } else {
            this.opaque = true;
            this.query = null;
            this.path = null;
            this.authority = null;
            Uri.validateSsp(encoded, string, n6 + 1);
        }
        this.schemeSpecificPart = new Encoded(string);
        this.input = string3 == encoded.get() ? encoded : new Encoded(string3);
        charSequence = null;
        Encoded encoded2 = null;
        n5 = -1;
        if (null != this.authority) {
            n4 = 1;
            n3 = 0;
            string2 = this.authority.get();
            n7 = string2.indexOf(64);
            if (n7 != -1) {
                charSequence = new Encoded(string2.substring(0, n7));
                Uri.validateUserinfo(this.authority, (Encoded)charSequence, 0);
                string2 = string2.substring(n7 + 1);
                n3 = n7 + 1;
            }
            n7 = string2.lastIndexOf(58);
            int n11 = string2.indexOf(93);
            if (n7 != -1 && n11 < n7) {
                encoded2 = new Encoded(string2.substring(0, n7));
                if (n7 < string2.length() - 1) {
                    try {
                        n5 = Integer.parseInt(string2.substring(n7 + 1));
                        if (n5 < 0) {
                            if (bl) {
                                Uri.fail(this.authority, "invalid port <" + this.authority + ">", n3 + n7 + 1);
                            }
                            n4 = 0;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (bl) {
                            Uri.fail(this.authority, "invalid port <" + this.authority + ">, " + numberFormatException.getMessage(), n3 + n7 + 1);
                        }
                        n4 = 0;
                    }
                }
            } else {
                encoded2 = new Encoded(string2);
            }
            if (n4 != 0) {
                if (Uri.emptyString(encoded2)) {
                    if (bl) {
                        Uri.fail(this.authority, "empty host <" + this.authority + ">", n3);
                    }
                    n4 = 0;
                } else if (!this.isValidHost(bl, encoded2)) {
                    if (bl) {
                        Uri.fail(this.authority, "invalid host <" + encoded2 + ">", n3);
                    }
                    n4 = 0;
                }
            }
        } else {
            n4 = 0;
        }
        if (n4 != 0) {
            this.userInfo = charSequence;
            this.host = encoded2;
            this.port = n5;
            this.hasAuthority = true;
        } else {
            this.userInfo = null;
            this.host = null;
            this.port = -1;
            this.hasAuthority = false;
        }
    }

    private static void validateScheme(Encoded encoded, Encoded encoded2, int n2) throws URISyntaxException {
        int n3;
        char c2 = encoded2.charAt(0);
        if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            Uri.fail(encoded, "invalid scheme", n2);
        }
        if (0 <= (n3 = Uri.validateAlphaNum(encoded2.get(), "+-."))) {
            Uri.fail(encoded, "invalid scheme", n2 + n3);
        }
    }

    private static void validateSsp(Encoded encoded, String string, int n2) throws URISyntaxException {
        int n3 = Uri.validateEncoded(string, "_-.~,;:$&+=!*'()@/?[]\\\"");
        if (0 <= n3) {
            Uri.fail(encoded, "invalid scheme-specific-part", n2 + n3);
        }
    }

    private static void validateAuthority(Encoded encoded, Encoded encoded2, int n2) throws URISyntaxException {
        int n3 = Uri.validateEncoded(encoded2.get(), AUTHORITY_LEGAL);
        if (0 <= n3) {
            Uri.fail(encoded, "invalid authority", n2 + n3);
        }
    }

    private static void validatePath(Encoded encoded, String string, int n2) throws URISyntaxException {
        int n3 = Uri.validateEncoded(string, PATH_LEGAL);
        if (0 <= n3) {
            Uri.fail(encoded, "invalid path", n2 + n3);
        }
    }

    private static void validateQuery(Encoded encoded, Encoded encoded2, int n2) throws URISyntaxException {
        int n3 = Uri.validateEncoded(encoded2.get(), "_-.~,;:$&+=!*'()@/?[]\\\"");
        if (0 <= n3) {
            Uri.fail(encoded, "invalid query", n2 + n3);
        }
    }

    private static void validateFragment(Encoded encoded, Encoded encoded2, int n2) throws URISyntaxException {
        int n3 = Uri.validateEncoded(encoded2.get(), FRAG_LEGAL);
        if (0 <= n3) {
            Uri.fail(encoded, "invalid fragment", n2 + n3);
        }
    }

    private static void validateUserinfo(Encoded encoded, Encoded encoded2, int n2) throws URISyntaxException {
        for (int i2 = 0; i2 < encoded2.length(); ++i2) {
            char c2 = encoded2.charAt(i2);
            if (c2 != ']' && c2 != '[') continue;
            Uri.fail(encoded, "invalid userinfo", n2 + i2);
        }
    }

    private boolean isValidHost(boolean bl, Encoded encoded) throws URISyntaxException {
        int n2;
        if (encoded.charAt(0) == '[') {
            if (encoded.charAt(encoded.length() - 1) != ']') {
                Uri.fail(this.input, "invalid host, missing closing ipv6: " + encoded, 0);
            }
            if (!Uri.isValidIP6Address(encoded.get())) {
                Uri.fail(this.input, "invalid ipv6: " + encoded, 0);
            }
            return true;
        }
        if (encoded.indexOf(91) != -1 || encoded.indexOf(93) != -1) {
            Uri.fail(this.input, "invalid host: " + encoded, 0);
        }
        if ((n2 = encoded.lastIndexOf(46)) < 0 || n2 == encoded.length() - 1 || !Character.isDigit(encoded.charAt(n2 + 1))) {
            if (Uri.isValidDomainName(encoded)) {
                return true;
            }
            if (bl) {
                Uri.fail(this.input, "invalid host, invalid domain-name or ipv4: " + encoded, 0);
            }
            return false;
        }
        if (Uri.isValidIPv4Address(encoded.get())) {
            return true;
        }
        if (bl) {
            Uri.fail(this.input, "invalid host, invalid ipv4: " + encoded, 0);
        }
        return false;
    }

    private static boolean isValidDomainName(Encoded encoded) {
        char c2;
        String string = encoded.get();
        if (0 <= Uri.validateAlphaNum(string, "-.")) {
            return false;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("-") && !string2.endsWith("-")) continue;
            return false;
        }
        return string2.equals(string) || (c2 = string2.charAt(0)) < '0' || c2 > '9';
    }

    private static boolean isValidIPv4Address(String string) {
        try {
            int n2 = string.indexOf(46);
            int n3 = Integer.parseInt(string.substring(0, n2));
            if (n3 < 0 || n3 > 255) {
                return false;
            }
            int n4 = string.indexOf(46, n2 + 1);
            n3 = Integer.parseInt(string.substring(n2 + 1, n4));
            if (n3 < 0 || n3 > 255) {
                return false;
            }
            n2 = string.indexOf(46, n4 + 1);
            n3 = Integer.parseInt(string.substring(n4 + 1, n2));
            if (n3 < 0 || n3 > 255) {
                return false;
            }
            n3 = Integer.parseInt(string.substring(n2 + 1));
            if (n3 < 0 || n3 > 255) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isValidIP6Address(String string) {
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        String string2 = "";
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n5 = 0;
        if (n2 < 2) {
            return false;
        }
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            c3 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '[': {
                    if (i2 != 0) {
                        return false;
                    }
                    if (string.charAt(n2 - 1) != ']') {
                        return false;
                    }
                    if (string.charAt(1) == ':' && string.charAt(2) != ':') {
                        return false;
                    }
                    n5 = 1;
                    if (n2 >= 4) continue block6;
                    return false;
                }
                case ']': {
                    if (i2 != n2 - 1) {
                        return false;
                    }
                    if (string.charAt(0) == '[') continue block6;
                    return false;
                }
                case '.': {
                    if (++n4 > 3) {
                        return false;
                    }
                    if (!Uri.isValidIP4Word(string2)) {
                        return false;
                    }
                    if (n3 != 6 && !bl) {
                        return false;
                    }
                    if (n3 == 7 && string.charAt(0 + n5) != ':' && string.charAt(1 + n5) != ':') {
                        return false;
                    }
                    string2 = "";
                    continue block6;
                }
                case ':': {
                    if (++n3 > 7) {
                        return false;
                    }
                    if (n4 > 0) {
                        return false;
                    }
                    if (c3 == ':') {
                        if (bl) {
                            return false;
                        }
                        bl = true;
                    }
                    string2 = "";
                    continue block6;
                }
                default: {
                    if (string2.length() > 3) {
                        return false;
                    }
                    if (!Uri.isValidHexChar(c2)) {
                        return false;
                    }
                    string2 = string2 + c2;
                }
            }
        }
        if (n4 > 0) {
            if (n4 != 3 || !Uri.isValidIP4Word(string2)) {
                return false;
            }
        } else {
            if (n3 != 7 && !bl) {
                return false;
            }
            if (string2 == "" && string.charAt(n2 - 1 - n5) != ':' && string.charAt(n2 - 2 - n5) != ':') {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidIP4Word(String string) {
        if (string.length() < 1 || string.length() > 3) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return Integer.parseInt(string) <= 255;
    }

    private static int validateEncoded(String string, String string2) {
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '%') {
                do {
                    if (n2 + 2 >= string.length()) {
                        throw new IllegalArgumentException("missing '%' hex-digits at index " + n2);
                    }
                    int n3 = Character.digit(string.charAt(n2 + 1), 16);
                    int n4 = Character.digit(string.charAt(n2 + 2), 16);
                    if (n3 != -1 && n4 != -1) continue;
                    throw new IllegalArgumentException("invalid hex-digits at index " + n2 + ": " + string.substring(n2, n2 + 3));
                } while ((n2 += 3) < string.length() && string.charAt(n2) == '%');
                continue;
            }
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || string2.indexOf(c2) > -1 || c2 > '\u007f' && !Character.isSpaceChar(c2) && !Character.isISOControl(c2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static int validateAlphaNum(String string, String string2) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || string2.indexOf(c2) > -1) continue;
            return i2;
        }
        return -1;
    }

    private static boolean isValidHexChar(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean emptyString(Encoded encoded) {
        return null == encoded || 0 == encoded.length();
    }

    private static boolean emptyString(String string) {
        return null == string || 0 == string.length();
    }

    private static void fail(Encoded encoded, String string, int n2) throws URISyntaxException {
        throw new URISyntaxException(encoded.get(), string, n2);
    }

    private static void failExpecting(Encoded encoded, String string, int n2) throws URISyntaxException {
        Uri.fail(encoded, "Expecting " + string, n2);
    }

    static {
        Debug.initSingleton();
        DEBUG = IOUtil.DEBUG || Debug.debug("Uri");
        DEBUG_SHOWFIX = PropertyAccess.isPropertyDefined("jogamp.debug.Uri.ShowFix", true);
        patternSingleFS = Pattern.compile("/{1}");
    }

    public static class ASCIIEncoded
    extends Encoded {
        public static ASCIIEncoded cast(String string) {
            return new ASCIIEncoded(string, (Object)null);
        }

        private ASCIIEncoded(String string, Object object) {
            super(string);
        }

        public ASCIIEncoded(String string) {
            super(Uri.encodeToASCIIString(string));
        }

        @Override
        public boolean isASCII() {
            return true;
        }
    }

    public static class Encoded
    implements Comparable<Encoded>,
    CharSequence {
        private final String s;

        public static Encoded cast(String string) {
            return new Encoded(string);
        }

        Encoded(String string) {
            this.s = string;
        }

        public Encoded(String string, String string2) {
            this.s = Uri.encode(string, string2);
        }

        public boolean isASCII() {
            return false;
        }

        public final String get() {
            return this.s;
        }

        public final String decode() {
            return Uri.decode(this.s);
        }

        @Override
        public final String toString() {
            return this.s;
        }

        public final int hashCode() {
            return this.s.hashCode();
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Encoded) {
                return this.s.equals(((Encoded)object).s);
            }
            return this.s.equals(object);
        }

        @Override
        public final int length() {
            return this.s.length();
        }

        @Override
        public final char charAt(int n2) {
            return this.s.charAt(n2);
        }

        @Override
        public final CharSequence subSequence(int n2, int n3) {
            return this.s.subSequence(n2, n3);
        }

        @Override
        public final int compareTo(Encoded encoded) {
            return this.s.compareTo(encoded.s);
        }

        public Encoded concat(Encoded encoded) {
            return new Encoded(this.s.concat(encoded.s));
        }

        public final Encoded substring(int n2) {
            return new Encoded(this.s.substring(n2));
        }

        public final Encoded substring(int n2, int n3) {
            return new Encoded(this.s.substring(n2, n3));
        }

        public final int indexOf(int n2) {
            return this.s.indexOf(n2);
        }

        public final int indexOf(int n2, int n3) {
            return this.s.indexOf(n2, n3);
        }

        public final int indexOf(String string) {
            return this.s.indexOf(string);
        }

        public final int indexOf(String string, int n2) {
            return this.s.indexOf(string, n2);
        }

        public final int lastIndexOf(int n2) {
            return this.s.lastIndexOf(n2);
        }

        public int lastIndexOf(int n2, int n3) {
            return this.s.lastIndexOf(n2, n3);
        }

        public int lastIndexOf(String string) {
            return this.s.lastIndexOf(string);
        }

        public int lastIndexOf(String string, int n2) {
            return this.s.lastIndexOf(string, n2);
        }

        public boolean startsWith(String string) {
            return this.s.startsWith(string);
        }

        public boolean startsWith(String string, int n2) {
            return this.s.startsWith(string, n2);
        }

        public boolean endsWith(String string) {
            return this.s.endsWith(string);
        }

        public final boolean equalsIgnoreCase(Encoded encoded) {
            return this.s.equalsIgnoreCase(encoded.s);
        }
    }
}

