/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.ToDoubleRounder;
import java.math.BigDecimal;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class BigDecimalMath {
    private BigDecimalMath() {
    }

    public static double roundToDouble(BigDecimal x2, RoundingMode mode) {
        return BigDecimalToDoubleRounder.INSTANCE.roundToDouble(x2, mode);
    }

    private static class BigDecimalToDoubleRounder
    extends ToDoubleRounder<BigDecimal> {
        static final BigDecimalToDoubleRounder INSTANCE = new BigDecimalToDoubleRounder();

        private BigDecimalToDoubleRounder() {
        }

        @Override
        double roundToDoubleArbitrarily(BigDecimal bigDecimal) {
            return bigDecimal.doubleValue();
        }

        @Override
        int sign(BigDecimal bigDecimal) {
            return bigDecimal.signum();
        }

        @Override
        BigDecimal toX(double d2, RoundingMode mode) {
            return new BigDecimal(d2);
        }

        @Override
        BigDecimal minus(BigDecimal a2, BigDecimal b2) {
            return a2.subtract(b2);
        }
    }
}

